/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class SoapException
extends Exception {
    private static final long serialVersionUID = 3747992778905099350L;
    private String errorCode;
    private transient Object errorDetails;
    private int httpStatusCode;

    public SoapException(int httpStatus, String errorCode, Object errorDetails) {
        if (errorCode == null || errorDetails == null) {
            throw new IllegalArgumentException("errorCode and errorDetail parameters must not be null");
        }
        this.validateAndSetDetail(errorDetails);
        this.httpStatusCode = httpStatus;
        this.errorCode = errorCode;
    }

    public void setStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public int getStatusCode() {
        return this.httpStatusCode;
    }

    private void validateAndSetDetail(Object detail) {
        if (detail instanceof JsonObject) {
            this.errorDetails = detail;
            return;
        }
        if (detail instanceof InputStream) {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)((InputStream)detail), (Writer)writer, (String)"UTF-8");
                this.errorDetails = ((Object)writer).toString();
            }
            catch (IOException e) {
                this.errorDetails = "";
            }
            return;
        }
        throw new IllegalArgumentException("Unsupported detail class");
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    public String getMessage() {
        StringWriter sw = new StringWriter();
        if (this.errorDetails instanceof JsonObject) {
            try {
                SoapException.writeMessage(sw, (JsonObject)this.errorDetails);
            }
            catch (IOException iOException) {}
        } else if (this.errorDetails instanceof String) {
            sw.write((String)this.errorDetails);
        }
        return sw.toString();
    }

    private static void writeMessage(Writer out, JsonObject obj) throws IOException {
        JsonWriter w = new JsonWriter(DefaultJsonFactory.instance, true);
        w.write(out, (Object)obj);
    }
}

