/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.commons.http.BIHttpClientPool;
import com.ibm.bi.platform.commons.http.util.HttpUtils;
import com.ibm.bi.soap.services.HttpTransport;
import com.ibm.bi.soap.services.SoapTransport;
import com.netflix.config.DynamicStringProperty;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public class SoapTransportFactory {
    private static SoapTransportFactory instance = null;
    private static final String DEFAULT_DISPATCHER_URI = "http://localhost:9300/p2pd/servlet/dispatch";
    private final DynamicStringProperty internalDispatcher;
    private final BIHttpClientPool clientPool = new BIHttpClientPool();

    public static SoapTransportFactory getInstance() {
        SoapTransportFactory result = instance;
        return result == null ? (instance = new SoapTransportFactory()) : result;
    }

    protected SoapTransportFactory() {
        this.internalDispatcher = ConfigurationPropertyFactory.getInstance().getStringProperty("internalDispatcher", DEFAULT_DISPATCHER_URI);
        this.clientPool.initialize("soap-bridge");
    }

    public SoapTransport create() throws Exception {
        return new HttpTransport(this.clientPool.getClient(), this.getDispatcherUrl());
    }

    public SoapTransport create(HttpServletRequest request) throws Exception {
        return new HttpTransport(this.clientPool.getClient(), this.getDispatcherUrl(request));
    }

    private String getDispatcherUrl() {
        String url = this.checkForOverride();
        if (url == null) {
            url = this.internalDispatcher.get();
        }
        return url;
    }

    private String getDispatcherUrl(HttpServletRequest request) {
        String disp = this.getDispatcherUrl();
        URL caEndpoint = HttpUtils.getCAEndpoint((HttpServletRequest)request);
        if (caEndpoint != null) {
            try {
                return caEndpoint.toString() + new URL(disp).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return disp;
    }

    private String checkForOverride() {
        return System.getProperty("soap-bridge.dispatcherURL");
    }
}

