/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.xml;

import com.ibm.bi.soap.xml.Namespace;
import com.ibm.bi.soap.xml.XMLWriterBase;
import java.io.OutputStream;
import java.io.Writer;

public abstract class SOAPWriterBase<T extends SOAPWriterBase<T>>
extends XMLWriterBase<T> {
    public SOAPWriterBase(Writer out) {
        super(out);
    }

    public SOAPWriterBase(OutputStream out, String encoding) {
        super(out, encoding);
    }

    public SOAPWriterBase(StringBuilder out) {
        super(out);
    }

    public T envelope() {
        return (T)((SOAPWriterBase)((SOAPWriterBase)((SOAPWriterBase)this.element(Namespace.SOAPENV, "Envelope")).namespace(Namespace.SOAPENC)).namespace(Namespace.XSI));
    }

    public T header() {
        return (T)((SOAPWriterBase)this.element(Namespace.SOAPENV, "Header"));
    }

    public T body() {
        return (T)((SOAPWriterBase)this.element(Namespace.SOAPENV, "Body"));
    }

    public T type(Namespace ns, String name) {
        if (this.trackNamespaces) {
            this.namespace(ns);
        }
        return (T)((SOAPWriterBase)this.rawAttr(Namespace.XSI, "type", this.getQName(ns, name)));
    }

    public T href(String value) {
        return (T)((SOAPWriterBase)this.rawAttr("href", "cid:" + value));
    }

    public T arrayType(Namespace ns, String type, int count) {
        this.type(Namespace.SOAPENC, "Array");
        if (this.trackNamespaces) {
            this.namespace(ns);
        }
        StringBuilder buf = new StringBuilder(32);
        buf.append(this.getQName(ns, type));
        buf.append('[');
        if (count >= 0) {
            buf.append(count);
        }
        buf.append(']');
        return (T)((SOAPWriterBase)this.rawAttr(Namespace.SOAPENC, "arrayType", buf.toString()));
    }

    public T xsiNil() {
        return (T)((SOAPWriterBase)this.rawAttr(Namespace.XSI, "nil", "true"));
    }

    public T encodingStyle(String encoding) {
        return (T)((SOAPWriterBase)this.rawAttr(Namespace.SOAPENV, "encodingStyle", encoding));
    }

    public T mustUnderstand() {
        return (T)((SOAPWriterBase)this.rawAttr(Namespace.SOAPENV, "mustUnderstand", "1"));
    }

    public T actor(String uri) {
        return (T)((SOAPWriterBase)this.rawAttr(Namespace.SOAPENV, "actor", uri));
    }

    public T fault(String faultcode, String faultstring) {
        this.element(Namespace.SOAPENV, "Fault");
        ((SOAPWriterBase)((SOAPWriterBase)((SOAPWriterBase)((SOAPWriterBase)this.element("faultcode")).text(Namespace.SOAPENV.getPrefix())).text(":")).text(faultcode)).end();
        return (T)((SOAPWriterBase)((SOAPWriterBase)((SOAPWriterBase)this.element("faultstring")).text(faultstring)).end());
    }
}

