/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.xml;

import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLUtils.class);
    private static final char[] ENCODED_QUOT = "&quot;".toCharArray();
    private static final char[] ENCODED_AMP = "&amp;".toCharArray();
    private static final char[] ENCODED_APOS = "&apos;".toCharArray();
    private static final char[] ENCODED_LT = "&lt;".toCharArray();
    private static final char[] ENCODED_GT = "&gt;".toCharArray();

    private XMLUtils() {
    }

    @Deprecated
    public static String escape(String str) {
        return XMLUtils.escapeElementText(str);
    }

    public static String escapeAttribute(String str) {
        return XMLUtils.escape(str, true);
    }

    public static String escapeElementText(String str) {
        return XMLUtils.escape(str, false);
    }

    public static String escape(String str, boolean isAttr) {
        block10: {
            int i;
            if (str == null || str.length() == 0) {
                return "";
            }
            int len = str.length();
            char[] entity = null;
            char[] chars = str.toCharArray();
            for (i = 0; i < len; ++i) {
                char ch = chars[i];
                if (ch == '<') {
                    entity = ENCODED_LT;
                    break;
                }
                if (ch == '>') {
                    entity = ENCODED_GT;
                    break;
                }
                if (ch == '\"') {
                    if (!isAttr) continue;
                    entity = ENCODED_QUOT;
                    break;
                }
                if (ch == '&') {
                    entity = ENCODED_AMP;
                    break;
                }
                if (ch != '\'' || !isAttr) continue;
                entity = ENCODED_APOS;
                break;
            }
            if (entity == null) break block10;
            StringBuilder buffer = new StringBuilder(len + 64);
            buffer.append(chars, 0, i);
            buffer.append(entity);
            int curPos = ++i;
            while (i < len) {
                block15: {
                    block12: {
                        char ch;
                        block16: {
                            block14: {
                                block13: {
                                    block11: {
                                        ch = chars[i];
                                        if (ch != '<') break block11;
                                        entity = ENCODED_LT;
                                        break block12;
                                    }
                                    if (ch != '>') break block13;
                                    entity = ENCODED_GT;
                                    break block12;
                                }
                                if (ch != '\"') break block14;
                                if (!isAttr) break block15;
                                entity = ENCODED_QUOT;
                                break block12;
                            }
                            if (ch != '&') break block16;
                            entity = ENCODED_AMP;
                            break block12;
                        }
                        if (ch != '\'' || !isAttr) break block15;
                        entity = ENCODED_APOS;
                    }
                    buffer.append(chars, curPos, i - curPos);
                    buffer.append(entity);
                    curPos = i + 1;
                }
                ++i;
            }
            buffer.append(chars, curPos, len - curPos);
            str = buffer.toString();
        }
        return str;
    }

    public static String unescape(String str) {
        if (str == null || str.length() < 1) {
            return "";
        }
        int len = str.length();
        int i = str.indexOf(38);
        if (i < 0) {
            return str;
        }
        int curPos = 0;
        char[] chars = str.toCharArray();
        StringBuilder buffer = new StringBuilder(len);
        try {
            do {
                int elen = 0;
                int ch = 38;
                char cch = chars[i + 1];
                if (cch == 'q') {
                    if (chars[i + 2] == 'u' && chars[i + 3] == 'o' && chars[i + 4] == 't') {
                        elen = 5;
                        ch = 34;
                    }
                } else if (cch == 'a') {
                    cch = chars[i + 2];
                    if (cch == 'm') {
                        if (chars[i + 3] == 'p') {
                            elen = 4;
                            ch = 38;
                        }
                    } else if (cch == 'p' && chars[i + 3] == 'o' && chars[i + 4] == 's') {
                        elen = 5;
                        ch = 39;
                    }
                } else if (cch == 'l') {
                    if (chars[i + 2] == 't') {
                        elen = 3;
                        ch = 60;
                    }
                } else if (cch == 'g' && chars[i + 2] == 't') {
                    elen = 3;
                    ch = 62;
                }
                if (chars[i + elen] == ';') {
                    buffer.append(chars, curPos, i - curPos);
                    buffer.append((char)ch);
                    curPos = i += elen + 1;
                    continue;
                }
                ++i;
            } while ((i = str.indexOf(38, i)) > 0);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error("unterminated entity reference");
        }
        buffer.append(chars, curPos, len - curPos);
        return buffer.toString();
    }

    public static String collapseWhiteSpace(String strToTokenize) {
        StringBuilder newStr = new StringBuilder(strToTokenize.length());
        StringTokenizer toker = new StringTokenizer(strToTokenize, "\t\n\r ");
        while (toker.hasMoreTokens()) {
            if (newStr.length() > 0) {
                newStr.append(" ");
            }
            newStr.append(toker.nextToken());
        }
        return newStr.toString();
    }
}

