/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.xml;

import com.ibm.bi.soap.xml.DefaultNamespace;
import com.ibm.bi.soap.xml.Namespace;
import com.ibm.bi.soap.xml.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;

public abstract class XMLWriterBase<T extends XMLWriterBase<T>> {
    private static final Namespace XMLNS = new DefaultNamespace(null, "xmlns");
    private static final int HASCONTENT = 1;
    private static final int MIXEDCONTENT = 2;
    protected boolean autoFlush = false;
    protected boolean trackNamespaces = true;
    protected boolean escapeText = true;
    private Writer out;
    private Exception ex;
    private Stack stack = new Stack();
    private NamespaceMap nsMap = new NamespaceMap();
    private StringBuilder buf = new StringBuilder(2048);
    private StringBuilder indents;
    private String indentStr;
    private int indentLevel;
    private String eol;

    protected XMLWriterBase(OutputStream os, String locale) {
        try {
            this.out = new OutputStreamWriter(os, locale);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected XMLWriterBase(Writer out) {
        this.out = out;
    }

    protected XMLWriterBase(StringBuilder b) {
        this.out = null;
        this.buf = b;
    }

    public void setAutoFlush(boolean flush) {
        this.autoFlush = flush;
    }

    public void setIndent(String indent, int level) {
        if (indent != null) {
            this.indentStr = indent;
            this.indents = new StringBuilder(indent.length() * (10 + level));
            for (int i = 0; i < level; ++i) {
                this.indents.append(indent);
            }
            this.indentLevel = this.stack.size();
            if (this.eol == null) {
                this.eol = System.getProperty("line.separator");
            }
        } else {
            this.indents = null;
            this.eol = null;
        }
    }

    public void setLineSeparator(String sep) {
        this.eol = sep != null ? sep : System.getProperty("line.separator");
    }

    public void setTrackNamespaces(boolean declare) {
        this.trackNamespaces = declare;
    }

    public boolean setEscapeText(boolean escape) {
        boolean result = this.escapeText;
        this.escapeText = escape;
        return result;
    }

    public void addNamespaces(Namespace ... namespaces) {
        for (Namespace ns : namespaces) {
            this.nsMap.map(ns);
        }
    }

    public Set<Namespace> getDeclaredNamespaces() {
        return new HashSet<Namespace>(this.nsMap.getDeclared());
    }

    public T xmlDecl(float version, String encoding) {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException();
        }
        this.append("<?xml version=\"");
        this.append(Float.toString(version));
        this.append("\" encoding=\"");
        this.append(encoding);
        this.append("\"?>");
        if (this.eol != null) {
            this.append(this.eol);
        }
        return this.This();
    }

    private void writeQName(Namespace ns, String name) {
        String prefix;
        if (ns != null && (prefix = ns.getPrefix()) != null) {
            this.append(prefix);
            this.append(':');
        }
        this.append(name);
    }

    protected String getQName(Namespace ns, String name) {
        if (ns != null && ns.getPrefix() != null) {
            return ns.getPrefix() + ':' + name;
        }
        return name;
    }

    public void clearError() {
        this.ex = null;
    }

    public Exception getError() {
        return this.ex;
    }

    public T namespace(Namespace ns) {
        Item top = this.stack.top();
        if (!this.trackNamespaces || this.nsMap.map(ns)) {
            top.addNsDecl(ns);
        }
        return this.This();
    }

    public T element(String name) {
        return this.element(null, name);
    }

    private void indent() {
        if (this.indents == null) {
            return;
        }
        int len = this.stack.size();
        int delta = len - this.indentLevel;
        if (delta > 0) {
            while (delta > 0) {
                this.indents.append(this.indentStr);
                --delta;
            }
        } else if (delta < 0) {
            this.indents.setLength(this.indents.length() + (delta *= this.indentStr.length()));
        }
        this.indentLevel = len;
        this.append(this.indents);
    }

    public T element(Namespace ns, String name) {
        this.closeElement(false);
        if (this.needIndent()) {
            if (!this.stack.isEmpty()) {
                this.println();
            }
            this.indent();
        }
        this.append('<');
        this.writeQName(ns, name);
        Item item = this.stack.push(ns, name);
        if (this.trackNamespaces && this.nsMap.map(ns)) {
            item.addNsDecl(ns);
        }
        return this.This();
    }

    private void closeElement(boolean mustExist) {
        if (!this.stack.isEmpty()) {
            Item top = this.stack.top();
            if ((top.flags & 1) == 0) {
                this.writeNsDecls(top);
                this.append('>');
                top.flags |= 1;
            }
        } else if (mustExist) {
            throw new IllegalStateException("no open elements");
        }
    }

    private void writeNsDecls(Item top) {
        if (top.nsDecls != null) {
            for (Namespace ns : top.nsDecls) {
                this.rawAttr(XMLNS, ns.getPrefix(), ns.getUri());
            }
        }
    }

    public T end() {
        Item item = this.stack.top();
        if ((item.flags & 1) != 0) {
            this.stack.pop();
            if (this.needIndent() && (item.flags & 2) == 0) {
                this.println();
                this.indent();
            }
            this.append("</");
            this.writeQName(item.namespace, item.name);
            this.append('>');
        } else {
            this.writeNsDecls(item);
            this.stack.pop();
            this.append("/>");
        }
        if (this.stack.isEmpty()) {
            this.println();
        }
        if (item.nsDecls != null) {
            for (Namespace ns : item.nsDecls) {
                this.nsMap.unmap(ns);
            }
        }
        if (this.stack.isEmpty() || this.autoFlush) {
            this.flush();
        }
        return this.This();
    }

    private final T This() {
        return (T)this;
    }

    public T attr(String name, String value) {
        return this.attr(null, name, value, this.escapeText);
    }

    public T attr(Namespace ns, String name, String value) {
        return this.attr(ns, name, value, this.escapeText);
    }

    public T rawAttr(String name, String value) {
        return this.attr(null, name, value, false);
    }

    public T rawAttr(Namespace ns, String name, String value) {
        return this.attr(ns, name, value, false);
    }

    private T attr(Namespace ns, String name, String value, boolean escape) {
        Item item = this.stack.top();
        if ((item.flags & 1) != 0) {
            throw new IllegalStateException("no open elements");
        }
        if (this.trackNamespaces && this.nsMap.map(ns)) {
            item.addNsDecl(ns);
        }
        this.append(' ');
        this.writeQName(ns, name);
        this.append("=\"");
        if (escape) {
            value = XMLUtils.escapeAttribute(value);
        }
        this.append(value);
        this.append('\"');
        return this.This();
    }

    public T comment(String text) {
        this.closeElement(false);
        if (this.needIndent()) {
            if (!this.stack.isEmpty()) {
                this.println();
            }
            this.indent();
        }
        this.append("<!-- ");
        this.append(text);
        this.append(" -->");
        if (this.stack.isEmpty()) {
            this.println();
        }
        return this.This();
    }

    public T cdata(String text) {
        this.closeElement(true);
        this.stack.top().flags |= 2;
        this.append("<![CDATA[");
        this.append(text);
        this.append("]]>");
        return this.This();
    }

    private T text(String text, boolean escape) {
        this.closeElement(true);
        this.stack.top().flags |= 2;
        if (escape) {
            text = XMLUtils.escapeElementText(text);
        }
        this.append(text);
        return this.This();
    }

    public T text(String text) {
        return this.text(text, this.escapeText);
    }

    public T rawText(String text) {
        return this.text(text, false);
    }

    protected final void append(char ch) {
        this.buf.append(ch);
    }

    protected final void append(String s) {
        this.buf.append(s);
        if (this.out != null && this.buf.length() >= 2048) {
            this.flush();
        }
    }

    protected final void append(StringBuilder b) {
        this.buf.append((CharSequence)b);
        if (this.out != null && this.buf.length() >= 2048) {
            this.flush();
        }
    }

    protected final void println() {
        if (this.indents != null && this.eol != null) {
            this.append(this.eol);
        }
    }

    private final boolean needIndent() {
        return this.indents != null && (this.stack.isEmpty() || (this.stack.top().flags & 2) == 0);
    }

    public void flush() {
        if (this.out != null && this.buf.length() != 0) {
            block3: {
                try {
                    this.out.write(this.buf.toString());
                    this.out.flush();
                }
                catch (IOException e) {
                    if (this.ex == null) break block3;
                    this.ex = e;
                }
            }
            this.buf.setLength(0);
        }
    }

    public void close() {
        block4: {
            if (!this.stack.isEmpty()) {
                throw new IllegalStateException("element tree is not empty");
            }
            this.flush();
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                if (this.ex == null) break block4;
                this.ex = e;
            }
        }
    }

    private static class Item {
        public String name;
        public Namespace namespace;
        public int flags;
        public ArrayList<Namespace> nsDecls;

        public Item(Namespace ns, String name) {
            this.namespace = ns;
            this.name = name;
        }

        public void addNsDecl(Namespace ns) {
            if (this.nsDecls == null) {
                this.nsDecls = new ArrayList();
            }
            this.nsDecls.add(ns);
        }
    }

    private static class NamespaceMap {
        IdentityHashMap<Namespace, Boolean> declared = new IdentityHashMap();

        private NamespaceMap() {
        }

        boolean map(Namespace ns) {
            if (ns == null || ns == XMLNS) {
                return false;
            }
            return this.declared.put(ns, Boolean.TRUE) == null;
        }

        void unmap(Namespace ns) {
            this.declared.remove(ns);
        }

        Set<Namespace> getDeclared() {
            return this.declared.keySet();
        }
    }

    private static class Stack
    extends ArrayList<Item> {
        private Stack() {
        }

        Item top() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Element stack is empty");
            }
            return (Item)this.get(this.size() - 1);
        }

        Item push(Namespace ns, String name) {
            Item item = new Item(ns, name);
            this.add(item);
            return item;
        }

        Item pop() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Element stack is empty");
            }
            return (Item)this.remove(this.size() - 1);
        }
    }
}

