/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.jni;

import com.cognos.accman.jcam.crypto.jni.AixMvsCryptoByteBuffer;
import com.cognos.accman.jcam.crypto.jni.LinuxCryptoByteBuffer;
import com.cognos.accman.jcam.crypto.jni.SolarisCryptoByteBuffer;
import com.cognos.accman.jcam.crypto.jni.WinCryptoByteBuffer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public abstract class CryptoByteBuffer {
    public static CryptoByteBuffer getInstance() {
        CryptoByteBuffer cbb = null;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            cbb = new WinCryptoByteBuffer();
        } else if (os.contains("linux")) {
            cbb = new LinuxCryptoByteBuffer();
        } else if (os.contains("aix") || os.contains("390")) {
            cbb = new AixMvsCryptoByteBuffer();
        } else if (os.contains("sunos")) {
            cbb = new SolarisCryptoByteBuffer();
        } else if (os.contains("mac")) {
            cbb = new LinuxCryptoByteBuffer();
        } else {
            throw new RuntimeException("CBB:getInstance: unsupported platform");
        }
        return cbb;
    }

    public byte[] getByteBuffer() {
        return null;
    }

    public abstract byte[] getByteBuffer2(int var1);

    public abstract byte[] getByteBuffer3(int var1);

    protected static BufferedReader executeSystemCommand(List<String> command) {
        BufferedReader bufferedReader = null;
        try {
            Process pb = new ProcessBuilder(command).start();
            bufferedReader = new BufferedReader(new InputStreamReader(pb.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("executeSystemCommand: IO exception when running command" + command.get(0));
        }
        return bufferedReader;
    }

    protected static String executeAndGetCommandOutput(List<String> command) {
        String cmdOutput = null;
        BufferedReader bufReader = CryptoByteBuffer.executeSystemCommand(command);
        try {
            String aLine;
            while ((aLine = bufReader.readLine()) != null) {
                String strippedLine = aLine.replaceAll("\\s", "");
                if (strippedLine.length() <= 0) continue;
                cmdOutput = strippedLine;
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("executeAndGetCommandOutput: IO exception when running command " + command.get(0));
        }
        return cmdOutput;
    }
}

