/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.json.JsonLaxParser;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DefaultJsonFactory
implements JsonFactory {
    public static final JsonFactory instance = new DefaultJsonFactory();

    @Override
    public JsonArray createArray() {
        return new JsonArray();
    }

    @Override
    public JsonObject createObject() {
        return new JsonObject();
    }

    @Override
    public Object createString(String value) {
        return value;
    }

    @Override
    public Object createLong(long value) {
        return value;
    }

    @Override
    public boolean isLong(Object value) {
        return value instanceof Long;
    }

    @Override
    public long toLong(Object value) {
        return (Long)value;
    }

    @Override
    public Object createDouble(double value) {
        return value;
    }

    @Override
    public boolean isDouble(Object value) {
        return value instanceof Double;
    }

    @Override
    public double toDouble(Object value) {
        return (Double)value;
    }

    @Override
    public Object createBigInteger(BigInteger value) {
        return value;
    }

    @Override
    public boolean isBigInteger(Object value) {
        return value instanceof BigInteger;
    }

    @Override
    public BigInteger toBigInteger(Object value) {
        return (BigInteger)value;
    }

    @Override
    public Object createBigDecimal(BigDecimal value) {
        return value;
    }

    @Override
    public boolean isBigDecimal(Object value) {
        return value instanceof BigDecimal;
    }

    @Override
    public BigDecimal toBigDecimal(Object value) {
        return (BigDecimal)value;
    }

    @Override
    public Object createBoolean(boolean value) {
        return value;
    }

    @Override
    public boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public boolean toBoolean(Object value) {
        return (Boolean)value;
    }

    @Override
    public Object createNull() {
        return null;
    }

    @Override
    public boolean isNull(Object value) {
        return value == null;
    }

    @Override
    public boolean isString(Object value) {
        return value instanceof String;
    }

    @Override
    public String toString(Object value) {
        return value == null ? "" : value.toString();
    }

    public static Object parseString(String s, boolean strict) throws IOException {
        if (s == null) {
            return null;
        }
        JsonParser parser = strict ? new JsonParser(instance) : new JsonLaxParser(instance);
        return parser.parse(new StringReader(s));
    }
}

