/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.api;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.keystore.SecretKeyProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.KEKRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientOperator;
import org.bouncycastle.cms.bc.BcCMSContentEncryptorBuilder;
import org.bouncycastle.cms.bc.BcKEKRecipient;
import org.bouncycastle.cms.bc.BcKEKRecipientInfoGenerator;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.engines.SEEDWrapEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.operator.InputDecryptor;
import org.bouncycastle.operator.bc.BcAESSymmetricKeyUnwrapper;
import org.bouncycastle.operator.bc.BcAESSymmetricKeyWrapper;
import org.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;
import org.bouncycastle.operator.bc.BcSymmetricKeyWrapper;

public class StreamCipherSession {
    public static final StreamCipherSession INSTANCE = new StreamCipherSession();
    private static final int DEFAULT_CRYPTO_BUFFER_SIZE = 2048;
    private static final SecureRandom sc = new SecureRandom();
    private final SecretKeyProvider secretKeyProvider;

    public StreamCipherSession() {
        this.secretKeyProvider = new SecretKeyProvider.CAMCskSecretKeyProvider();
    }

    public StreamCipherSession(SecretKeyProvider secretKeyProvider) {
        this.secretKeyProvider = secretKeyProvider;
    }

    public InputStream decrypt(InputStream decryptionSource) throws CAMCryptoException {
        return this.decrypt(decryptionSource, 2048);
    }

    public InputStream decrypt(InputStream decryptionSource, int decryptionBufferSize) throws CAMCryptoException {
        try {
            RecipientInformation recipientInformation;
            RecipientId recipientId;
            CMSEnvelopedDataParser cmsEnvelopedDataParser = new CMSEnvelopedDataParser(decryptionSource);
            if (cmsEnvelopedDataParser.getRecipientInfos().size() == 1 && (recipientId = (recipientInformation = (RecipientInformation)cmsEnvelopedDataParser.getRecipientInfos().iterator().next()).getRID()) instanceof KEKRecipientId) {
                byte[] secretKeyAliasHash = ((KEKRecipientId)recipientId).getKeyIdentifier();
                SecretKey secretKey = this.secretKeyProvider.key(secretKeyAliasHash);
                CMSTypedStream recData = recipientInformation.getContentStream((Recipient)new CAMKEKEnvelopedRecipient(StreamCipherSession.keyUnwrapper(secretKey), decryptionBufferSize));
                return recData.getContentStream();
            }
            throw new CAMCryptoException(CamCryptoMessageKeys.decrypted_input_stream_creation_error.buildMessage());
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.decrypted_input_stream_creation_error.buildMessage());
        }
    }

    private static BcSymmetricKeyUnwrapper keyUnwrapper(SecretKey secretKey) throws CAMCryptoException {
        String algorithm = secretKey.getAlgorithm();
        if (algorithm.startsWith("AES")) {
            return new BcAESSymmetricKeyUnwrapper(new KeyParameter(secretKey.getEncoded()));
        }
        if (algorithm.startsWith("DES") || algorithm.startsWith("TripleDES")) {
            return new BcSymmetricKeyUnwrapper(StreamCipherSession.algorithmIdentifier(secretKey), (Wrapper)new SEEDWrapEngine(), new KeyParameter(secretKey.getEncoded()));
        }
        throw new CAMCryptoException(new UnsupportedOperationException("Unsupported secret key algorithm: " + algorithm), CamCryptoMessageKeys.encrypted_output_stream_creation_error.buildMessage());
    }

    private static AlgorithmIdentifier algorithmIdentifier(SecretKey secretKey) {
        try {
            Class<?> jceSymmetricKeyWrapperClass = Class.forName("org.bouncycastle.operator.jcajce.JceSymmetricKeyWrapper");
            Method determineKeyEncAlgMethod = jceSymmetricKeyWrapperClass.getDeclaredMethod("determineKeyEncAlg", SecretKey.class);
            determineKeyEncAlgMethod.setAccessible(true);
            return (AlgorithmIdentifier)determineKeyEncAlgMethod.invoke(null, secretKey);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public OutputStream encrypt(OutputStream encryptionSink) throws CAMCryptoException {
        return this.encrypt(encryptionSink, 2048);
    }

    public OutputStream encrypt(OutputStream encryptionSink, int encryptionBufferSize) throws CAMCryptoException {
        try {
            SecretKey secretKey = this.secretKeyProvider.defaultKey();
            byte[] secretKeyAlias = this.secretKeyProvider.keyAlias(secretKey);
            CMSEnvelopedDataStreamGenerator cmsEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
            cmsEnvelopedDataStreamGenerator.setBufferSize(encryptionBufferSize);
            cmsEnvelopedDataStreamGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new BcKEKRecipientInfoGenerator(secretKeyAlias, StreamCipherSession.keyWrapper(secretKey)));
            return cmsEnvelopedDataStreamGenerator.open(encryptionSink, new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).build());
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.encrypted_output_stream_creation_error.buildMessage());
        }
    }

    private static BcSymmetricKeyWrapper keyWrapper(SecretKey secretKey) throws CAMCryptoException {
        String algorithm = secretKey.getAlgorithm();
        if (algorithm.startsWith("AES")) {
            BcAESSymmetricKeyWrapper bcAESSymmetricKeyWrapper = new BcAESSymmetricKeyWrapper(new KeyParameter(secretKey.getEncoded()));
            bcAESSymmetricKeyWrapper.setSecureRandom(sc);
            return bcAESSymmetricKeyWrapper;
        }
        if (algorithm.startsWith("DES") || algorithm.startsWith("TripleDES")) {
            BcSymmetricKeyWrapper bcSymmetricKeyWrapper = new BcSymmetricKeyWrapper(StreamCipherSession.algorithmIdentifier(secretKey), (Wrapper)new SEEDWrapEngine(), new KeyParameter(secretKey.getEncoded()));
            bcSymmetricKeyWrapper.setSecureRandom(sc);
            return bcSymmetricKeyWrapper;
        }
        throw new CAMCryptoException(new UnsupportedOperationException("Unsupported secret key algorithm: " + algorithm), CamCryptoMessageKeys.encrypted_output_stream_creation_error.buildMessage());
    }

    private class CAMKEKEnvelopedRecipient
    extends BcKEKRecipient {
        private final int bufferSize;

        public CAMKEKEnvelopedRecipient(BcSymmetricKeyUnwrapper unwrapper, int bufferSize) {
            super(unwrapper);
            this.bufferSize = bufferSize;
        }

        public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
            Object dataCipher;
            KeyParameter secretKey = (KeyParameter)this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
            try {
                Class<?> envelopedDataHelperClass = Class.forName("org.bouncycastle.cms.bc.EnvelopedDataHelper");
                Method createContentCipherMethod = envelopedDataHelperClass.getDeclaredMethod("createContentCipher", Boolean.TYPE, CipherParameters.class, AlgorithmIdentifier.class);
                createContentCipherMethod.setAccessible(true);
                dataCipher = createContentCipherMethod.invoke(null, false, secretKey, contentEncryptionAlgorithm);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
            return new RecipientOperator(new InputDecryptor(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return contentEncryptionAlgorithm;
                }

                public InputStream getInputStream(InputStream dataOut) {
                    if (dataCipher instanceof BufferedBlockCipher) {
                        return new CipherInputStream(dataOut, (BufferedBlockCipher)dataCipher, CAMKEKEnvelopedRecipient.this.bufferSize);
                    }
                    return new CipherInputStream(dataOut, (StreamCipher)dataCipher, CAMKEKEnvelopedRecipient.this.bufferSize);
                }
            });
        }
    }
}

