/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.keystore;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CAMCryptoRuntimeException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMKeyStore;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMKeyStoreJKS;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class CAMKeyStorePKCS12
extends CAMKeyStore {
    public CAMKeyStorePKCS12(String keyStorePath, char[] password) throws CAMCryptoException {
        super(keyStorePath, password);
        this.init("PKCS12");
    }

    public CAMKeyStoreJKS toJksCAMKeyStoreWithNoValidations(String jksKeyStorePath) throws CAMCryptoException {
        CAMKeyStoreJKS mutableCAMKeyStoreJKS = new CAMKeyStoreJKS(jksKeyStorePath, this.password);
        mutableCAMKeyStoreJKS.clear();
        this.withKeystoreEntries(mutableCAMKeyStoreJKS, this);
        return mutableCAMKeyStoreJKS;
    }

    private void withKeystoreEntries(CAMKeyStoreJKS destination, CAMKeyStorePKCS12 source) throws CAMCryptoException {
        source.aliases().forEach(alias -> {
            try {
                if (source.getTrustedCertificate((String)alias) != null) {
                    destination.addTrustedCertificate(alias.toLowerCase(), source.getTrustedCertificate((String)alias));
                } else {
                    PrivateKey privateKey = source.getPrivateKey((String)alias);
                    Certificate[] certChain = source.getCertificateChain((String)alias);
                    destination.addPrivateKeyWithCertChain(alias.toLowerCase(), privateKey, certChain);
                }
            }
            catch (CAMCryptoException e) {
                throw new CAMCryptoRuntimeException(new CAMCryptoException((Throwable)((Object)e), CamCryptoMessageKeys.could_not_copy_keystore.buildMessage()));
            }
        });
    }
}

