/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CAMCryptoRuntimeException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMKeyStore;
import com.ibm.bi.platform.commons.crypto.internal.utils.CertificatesUtils;
import com.ibm.bi.platform.commons.crypto.internal.utils.Constants;
import com.ibm.bi.platform.commons.crypto.internal.utils.CryptoParams;
import com.ibm.bi.platform.commons.crypto.internal.utils.GenericUtils;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.crypto.internal.utils.Validator;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.commons.messages.Message;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAKey;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class CAMValidators {
    public static final Validator<PrivateKey> PRIVATE_KEY_MIN_LENGTH_VALIDATOR = privateKey -> {
        String keyCryptoAlgorithm;
        switch (keyCryptoAlgorithm = privateKey.getAlgorithm().toLowerCase()) {
            case "rsa": {
                int RSA_PRIVATE_KEY_MIN_LENGTH = CryptoParams.getInstance().minKeyLength("rsa");
                int actualKeyLength = ((RSAKey)((Object)privateKey)).getModulus().bitLength();
                boolean isValid = actualKeyLength >= RSA_PRIVATE_KEY_MIN_LENGTH;
                List<Message> messages = isValid ? null : Arrays.asList(CamCryptoMessageKeys.key_length_not_valid.buildMessage((Object)"RSA", (Object)RSA_PRIVATE_KEY_MIN_LENGTH, (Object)actualKeyLength));
                return new Validator.ValidatorResult(isValid, messages);
            }
            case "ec": {
                int EC_PRIVATE_KEY_MIN_LENGTH = CryptoParams.getInstance().minKeyLength("ec");
                int actualKeyLength = ((ECPrivateKey)privateKey).getS().bitLength();
                boolean isValid = actualKeyLength >= EC_PRIVATE_KEY_MIN_LENGTH;
                List<Message> messages = isValid ? null : Arrays.asList(CamCryptoMessageKeys.key_length_not_valid.buildMessage((Object)"EC", (Object)EC_PRIVATE_KEY_MIN_LENGTH, (Object)actualKeyLength));
                return new Validator.ValidatorResult(isValid, messages);
            }
        }
        return new Validator.ValidatorResult(false, Arrays.asList(CamCryptoMessageKeys.crypto_algorithm_not_supported.buildMessage((Object)keyCryptoAlgorithm, (Object)"length verification")));
    };
    public static final Validator<KeyPair> KEY_PAIR_MATCH_VALIDATOR = keyPair -> {
        boolean isValid = false;
        Message message = null;
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        if (privateKey.getAlgorithm().toLowerCase().equals(publicKey.getAlgorithm().toLowerCase())) {
            try {
                switch (privateKey.getAlgorithm().toLowerCase()) {
                    case "rsa": {
                        isValid = CAMValidators.signatureBasedKeyPairVerification(privateKey, publicKey, CryptoParams.getInstance().signatureAlgorithm("RSA"));
                        break;
                    }
                    case "ec": {
                        isValid = CAMValidators.signatureBasedKeyPairVerification(privateKey, publicKey, CryptoParams.getInstance().signatureAlgorithm("EC"));
                        break;
                    }
                    default: {
                        new Message(CamCryptoMessageKeys.crypto_algorithm_not_supported, (Object)privateKey.getAlgorithm().toLowerCase(), (Object)"KeyPair matching validation");
                        break;
                    }
                }
            }
            catch (CAMCryptoException e) {
                message = new Message(CamCryptoMessageKeys.keypair_validation_problem);
            }
        } else {
            message = new Message(CamCryptoMessageKeys.keypair_validation_problem);
        }
        return new Validator.ValidatorResult(isValid, GenericUtils.buildListSafely(message));
    };
    public static final Validator<Certificate> CERTIFICATE_VALIDATOR = certificate -> {
        boolean certValid = CertificatesUtils.isCertValid(certificate);
        Message message = null;
        if (!certValid) {
            message = CamCryptoMessageKeys.certificate_has_expired.buildMessage((Object)GenericUtils.supplierToOptional(() -> ((X509Certificate)certificate).getSubjectX500Principal().getName()).orElse("_"), (Object)GenericUtils.supplierToOptional(() -> ((X509Certificate)certificate).getNotBefore().toString()).orElse("_"), (Object)GenericUtils.supplierToOptional(() -> ((X509Certificate)certificate).getNotAfter().toString()).orElse("_"), (Object)Constants.CERTS_VALIDATION_REFERENCE_DATE.toString());
        }
        return new Validator.ValidatorResult(certValid, GenericUtils.buildListSafely(message));
    };

    private static boolean signatureBasedKeyPairVerification(PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm) throws CAMCryptoException {
        try {
            byte[] msg = "ENIGMA".getBytes("UTF-8");
            Signature signature = JcaFactory.getInstance(Signature.class, signatureAlgorithm);
            signature.initSign(privateKey);
            signature.update(msg);
            byte[] signedEnigma = signature.sign();
            signature.initVerify(publicKey);
            signature.update(msg);
            return signature.verify(signedEnigma);
        }
        catch (JcaFactory.CouldNotGetInstanceException | UnsupportedEncodingException | InvalidKeyException | SignatureException e) {
            throw new CAMCryptoException(e, null);
        }
    }

    public static final Validator<Certificate[]> certificateChainPkixValidator(CAMKeyStore trustAnchorsKeyStore) {
        Objects.requireNonNull(trustAnchorsKeyStore);
        return certificates -> {
            if (certificates != null && ((Certificate[])certificates).length > 0) {
                X509Certificate[] x509Certificates = (X509Certificate[])Arrays.stream(certificates).map(certificate -> (X509Certificate)certificate).toArray(X509Certificate[]::new);
                boolean isPkixValid = false;
                Message message = null;
                try {
                    isPkixValid = CertificatesUtils.isCertChainPkixValid(x509Certificates[0], Arrays.stream(x509Certificates).skip(1L).collect(Collectors.toList()), trustAnchorsKeyStore.getTrustedCertificates());
                }
                catch (CAMCryptoException e) {
                    IMessageKey.Param0 messageKey = (IMessageKey.Param0)CAMValidators.messageKey(e).orElse((IMessageKey)CamCryptoMessageKeys.cert_chain_not_valid);
                    message = new Message(messageKey);
                }
                return new Validator.ValidatorResult(isPkixValid, GenericUtils.buildListSafely(message));
            }
            throw new CAMCryptoRuntimeException(new CAMCryptoException(CamCryptoMessageKeys.certificate_chain_should_not_be_empty.buildMessage()));
        };
    }

    private static Optional<IMessageKey> messageKey(CAMCryptoException e) {
        IMessageKey messageKey = null;
        try {
            messageKey = e.getMessageKey();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.ofNullable(messageKey);
    }
}

