/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherSuiteManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CipherSuiteManager.class);
    private static CipherSuiteManager csmgr = null;
    private static Object csmgrLock = new Object();
    private Map<String, List<String>> internalToJvmSuiteNames = new HashMap<String, List<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CipherSuiteManager getInstance() {
        if (csmgr == null) {
            Object object = csmgrLock;
            synchronized (object) {
                if (csmgr == null) {
                    csmgr = new CipherSuiteManager();
                }
            }
        }
        return csmgr;
    }

    private CipherSuiteManager() {
        this.internalToJvmSuiteNames.put("RSA-RSA-AES(256)CBC-SHA", Arrays.asList("SSL_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"));
        this.internalToJvmSuiteNames.put("RSA-RSA-AES(256)CBC-SHA256", Arrays.asList("SSL_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256"));
        this.internalToJvmSuiteNames.put("RSA-RSA-AES(256)GCM-SHA384", Arrays.asList("TLS_RSA_WITH_AES_256_GCM_SHA384"));
        this.internalToJvmSuiteNames.put("RSA-RSA-AES(128)CBC-SHA", Arrays.asList("SSL_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA"));
        this.internalToJvmSuiteNames.put("RSA-RSA-AES(128)CBC-SHA256", Arrays.asList("SSL_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256"));
        this.internalToJvmSuiteNames.put("RSA-RSA-AES(128)GCM-SHA256", Arrays.asList("SSL_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256"));
        this.internalToJvmSuiteNames.put("ECDHE-ECDSA-AES(128)CBC-SHA", Arrays.asList("SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA"));
        this.internalToJvmSuiteNames.put("ECDHE-ECDSA-AES(128)CBC-SHA256", Arrays.asList("SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"));
        this.internalToJvmSuiteNames.put("ECDHE-ECDSA-AES(128)GCM-SHA256", Arrays.asList("SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"));
        this.internalToJvmSuiteNames.put("ECDHE-ECDSA-AES(256)CBC-SHA", Arrays.asList("SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA"));
        this.internalToJvmSuiteNames.put("ECDHE-ECDSA-AES(256)CBC-SHA384", Arrays.asList("SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384"));
        this.internalToJvmSuiteNames.put("ECDHE-ECDSA-AES(256)GCM-SHA384", Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"));
        this.internalToJvmSuiteNames.put("ECDHE-RSA-AES(128)CBC-SHA", Arrays.asList("SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"));
        this.internalToJvmSuiteNames.put("ECDHE-RSA-AES(128)CBC-SHA256", Arrays.asList("SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"));
        this.internalToJvmSuiteNames.put("ECDHE-RSA-AES(128)GCM-SHA256", Arrays.asList("SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"));
        this.internalToJvmSuiteNames.put("ECDHE-RSA-AES(256)CBC-SHA", Arrays.asList("SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"));
        this.internalToJvmSuiteNames.put("ECDHE-RSA-AES(256)CBC-SHA384", Arrays.asList("SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384"));
        this.internalToJvmSuiteNames.put("ECDHE-RSA-AES(256)GCM-SHA384", Arrays.asList("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"));
    }

    public String[] getCipherSuites(SSLContext sslContext) {
        String[] cipherSuites = null;
        String[] supportedCipherSuites = this.getSupportedCipherSuites(sslContext);
        String[] desiredCipherSuites = this.getDesiredCipherSuites();
        cipherSuites = desiredCipherSuites != null ? this.getEffectiveCipherSuites(supportedCipherSuites, desiredCipherSuites) : supportedCipherSuites;
        return cipherSuites;
    }

    private String[] getEffectiveCipherSuites(String[] supportedCipherSuites, String[] desiredCipherSuites) {
        ArrayList<String> cipherSuiteList = new ArrayList<String>();
        for (String aCipherSuite : desiredCipherSuites) {
            List<String> extJvmCipherSuiteNames;
            if (aCipherSuite != null && aCipherSuite.length() > 0 && (extJvmCipherSuiteNames = this.internalToJvmSuiteNames.get(aCipherSuite)) != null) {
                cipherSuiteList.addAll(extJvmCipherSuiteNames);
            }
            cipherSuiteList.retainAll(Arrays.asList(supportedCipherSuites));
        }
        boolean useConfidentiality = JCAMCryptoConfiguration.getProvider().getSSLConfidentiality();
        if (!useConfidentiality) {
            cipherSuiteList.add("SSL_RSA_WITH_NULL_SHA");
            cipherSuiteList.add("SSL_RSA_WITH_NULL_MD5");
        }
        return cipherSuiteList.toArray(new String[cipherSuiteList.size()]);
    }

    private String[] getSupportedCipherSuites(SSLContext sslContext) {
        String[] supportedCipherSuites = sslContext.getSocketFactory().getSupportedCipherSuites();
        return supportedCipherSuites;
    }

    private String[] getDesiredCipherSuites() {
        String[] desiredCipherSuites = null;
        String cfgCipherSuites = JCAMCryptoConfiguration.getProvider().getCognosCryptoCiphersuite();
        if (cfgCipherSuites != null) {
            desiredCipherSuites = cfgCipherSuites.split(",");
        }
        return desiredCipherSuites;
    }
}

