/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.internal.utils.GenericUtils;
import com.ibm.bi.platform.commons.crypto.internal.utils.Tuples;
import java.util.Date;
import java.util.Map;

public class Constants {
    public static final String PEM_CERTIFICATE_TYPE = "CERTIFICATE";
    public static final String X509_V3_BASIC_CONSTRAINTS_OID = "2.5.29.19";
    public static final String X509_V3_SUBJECT_KEY_ID_OID = "2.5.29.14";
    public static final String X509_V3_KEY_USAGE_OID = "2.5.29.15";
    public static final String X509_V3_EXTENDED_KEY_USAGE_OID = "2.5.29.37";
    public static final String PEM_CERTIFICATE_REQUEST_TYPE = "CERTIFICATE REQUEST";
    public static final String DEFAULT_PKI_KEYPAIR_ALIAS = "encryption";
    public static final String DEFAULT_CA_ROOT_ALIAS = "ca";
    public static final String PKCS_12 = "pkcs12";
    public static final String JKS = "jks";
    private static final Map<String, String> oidToPublicKeyAlgorithm = GenericUtils.mapFromKeyValTuples(new Tuples.Tuple2<String, String>("1.2.840.10045.2.1", "EC"), new Tuples.Tuple2<String, String>("1.2.840.113549.1.1.1", "RSA"));
    public static Date CERTS_VALIDATION_REFERENCE_DATE = new Date();
    public static Date CERTS_GENERATION_DEFAULT_START_DATE = new Date();

    public static String publicKeyAlgorithm(String oid) {
        return oidToPublicKeyAlgorithm.get(oid);
    }
}

