/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfiguration;
import com.ibm.bi.platform.commons.crypto.internal.utils.CAMConfiguration;
import com.ibm.bi.platform.commons.crypto.internal.utils.IJVMEnvironment;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.messages.Message;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMEnvironment
implements IJVMEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(JVMEnvironment.class);
    private static final String IBM_JCE_CLASS = "com.ibm.crypto.provider.IBMJCE";
    private static final String SUN_JCE_CLASS = "com.sun.crypto.provider.SunJCE";
    private static final String IBM_JSSE2_CLASS = "com.ibm.jsse2.IBMJSSEProvider2";
    private static final String IBM_JSSE_CLASS = "com.ibm.jsse.IBMJSSEProvider";
    private static final String IBM_JCE_PROV = "IBMJCE";
    private static final String SUN_JCE_PROV = "SunJCE";
    private static final String FIPS_MODE_FILE = System.getProperty("install.dir") + "./configuration/FIPS.mode";
    private static final String IBM_JCE_FIPS_PROV = "IBMJCEFIPS";
    private static final String IBM_JCE_FIPS_CLASS = "com.ibm.crypto.fips.provider.IBMJCEFIPS";
    private static final String PKCS12KEYSTORE_TYPE_FIPS = "PKCS12-3DES-3DES";
    private static final String PKCS12KEYSTORE_TYPE = "PKCS12-DEF";
    private static final String FALSE = "false";
    private static IJVMEnvironment s_instance = null;
    private String jceProviderName;
    private String jceProviderClass;
    private String jsseProtocolName;
    private String pbeProviderName;
    private String httpsProtocolHandler;
    private SecureRandom secureRandom;
    private boolean completedSetup = false;
    private boolean isFIPSEnabled = false;
    private boolean onlyUseSHA_2 = false;
    private boolean rejectNonFipsJavaScriptHashes = false;
    private static boolean isIBMJava = true;
    private static boolean isDisableNIST131a = false;
    private String forcedProvidertype;

    public static IJVMEnvironment getInstance() throws CAMCryptoException {
        if (s_instance == null) {
            s_instance = new JVMEnvironment(null, null);
        }
        if (s_instance instanceof JVMEnvironment) {
            ((JVMEnvironment)s_instance).completeSetup();
        }
        return s_instance;
    }

    public static void setInstance(IJVMEnvironment inst) throws CAMCryptoException {
        s_instance = inst;
    }

    public static void deleteInstance() {
        if (s_instance != null) {
            s_instance = null;
        }
    }

    public JVMEnvironment(String fipsModeConfig, String forcedProvidertype) throws CAMCryptoException {
        this.forcedProvidertype = forcedProvidertype;
        String fipsFile = null;
        fipsFile = fipsModeConfig == null ? FIPS_MODE_FILE : fipsModeConfig;
        this.parseFIPSModeSetting(fipsFile);
        if (JVMEnvironment.canProviderClassBeFound(IBM_JCE_CLASS)) {
            if (this.isFIPSEnabled) {
                this.jceProviderName = IBM_JCE_FIPS_PROV;
                this.jceProviderClass = IBM_JCE_FIPS_CLASS;
                this.pbeProviderName = IBM_JCE_PROV;
            } else {
                this.jceProviderName = IBM_JCE_PROV;
                this.jceProviderClass = IBM_JCE_CLASS;
                this.pbeProviderName = IBM_JCE_PROV;
            }
            isIBMJava = true;
        } else if (JVMEnvironment.canProviderClassBeFound(SUN_JCE_CLASS)) {
            this.jceProviderName = SUN_JCE_PROV;
            this.jceProviderClass = SUN_JCE_CLASS;
            this.pbeProviderName = SUN_JCE_PROV;
            isIBMJava = false;
        } else {
            Exception e1 = null;
            try {
                Class.forName(IBM_JCE_CLASS);
            }
            catch (Exception e) {
                e1 = e;
            }
            if (e1 != null && !(e1 instanceof ClassNotFoundException)) {
                throw new CAMCryptoException(e1, new Message(CamCryptoMessageKeys.jvm_env_could_not_find_jce, (Object)IBM_JCE_CLASS));
            }
            Exception e2 = null;
            try {
                Class.forName(SUN_JCE_CLASS);
            }
            catch (Exception e) {
                e2 = e;
            }
            if (e2 != null && !(e2 instanceof ClassNotFoundException)) {
                throw new CAMCryptoException(e2, new Message(CamCryptoMessageKeys.jvm_env_could_not_find_jce, (Object)SUN_JCE_CLASS));
            }
            throw new CAMCryptoException(new Message(CamCryptoMessageKeys.jvm_env_could_not_find_jce, (Object)"com.ibm.crypto.provider.IBMJCE/com.sun.crypto.provider.SunJCE"));
        }
        this.httpsProtocolHandler = "com.sun.net.ssl.internal.www.protocol";
        if (JVMEnvironment.canProviderClassBeFound(IBM_JSSE2_CLASS)) {
            this.httpsProtocolHandler = "com.ibm.net.ssl.www2.protocol";
        } else if (JVMEnvironment.canProviderClassBeFound(IBM_JSSE_CLASS)) {
            this.httpsProtocolHandler = "com.ibm.net.ssl.www.protocol";
        }
        String jvmVersion = System.getProperty("java.version");
        LOGGER.trace("JVM is version '" + jvmVersion + "'");
        LOGGER.trace("JCE provider is '" + this.jceProviderName + "'");
        LOGGER.trace("JCE provider class is '" + this.jceProviderClass + "'");
        LOGGER.trace("PBE provider is '" + this.pbeProviderName + "'");
        LOGGER.trace("HTTPS URL protocol handler is '" + this.httpsProtocolHandler + "'");
    }

    @Override
    public boolean isFIPSSupportedOS() throws CAMCryptoException {
        return this.isFIPSSupportedOS(true);
    }

    @Override
    public boolean isFIPSSupportedOS(boolean isConfigTool) throws CAMCryptoException {
        boolean isOSVioliation;
        if (this.isFIPSEnabled && (isOSVioliation = CAMConfiguration.getInstance().CheckFIPSOsViolation())) {
            throw new CAMCryptoException(new Message(CamCryptoMessageKeys.not_supported_fips_OS));
        }
        return true;
    }

    private void parseFIPSModeSetting(String fipsFile) throws CAMCryptoException {
        try (BufferedReader r = new BufferedReader(new FileReader(fipsFile));){
            this.isFIPSEnabled = true;
            this.onlyUseSHA_2 = true;
            this.rejectNonFipsJavaScriptHashes = true;
            String line = null;
            while ((line = r.readLine()) != null) {
                int index = line.indexOf(61);
                if (index == -1) continue;
                String name = line.substring(0, index);
                String value = line.substring(index + 1);
                if ((name = name.trim()).equalsIgnoreCase("OnlyUseSHA-2") && (value = value.trim()).equalsIgnoreCase(FALSE)) {
                    this.onlyUseSHA_2 = false;
                }
                if (!name.equalsIgnoreCase("RejectNonFipsJavaScriptHashes") || !(value = value.trim()).equalsIgnoreCase(FALSE)) continue;
                this.rejectNonFipsJavaScriptHashes = false;
            }
        }
        catch (FileNotFoundException e) {
            this.isFIPSEnabled = false;
            this.onlyUseSHA_2 = false;
            this.rejectNonFipsJavaScriptHashes = false;
        }
        catch (IOException e) {
            LOGGER.trace("Problem reading FIPS file: " + fipsFile + e.toString());
        }
    }

    @Override
    public boolean OnlyUseSHA_2() {
        return this.onlyUseSHA_2;
    }

    @Override
    public boolean RejectNonFipsJavaScriptHashes() {
        return this.rejectNonFipsJavaScriptHashes;
    }

    private void completeSetup() throws CAMCryptoException {
        if (this.completedSetup) {
            return;
        }
        String providerType = null;
        providerType = this.forcedProvidertype != null ? this.forcedProvidertype : JCAMCryptoConfiguration.getProvider().getCryptoProvider();
        this.setupSecureRandom(providerType);
        LOGGER.trace("SecureRandom provider is '" + this.secureRandom.getProvider().getName() + "'");
        this.completedSetup = true;
    }

    private void setupSecureRandom(String providerType) throws CAMCryptoException {
        try {
            this.secureRandom = SecureRandom.getInstance("SHA2DRBG", this.jceProviderName);
        }
        catch (NoSuchAlgorithmException nsae) {
            if (this.isFIPSEnabled) {
                try {
                    this.secureRandom = SecureRandom.getInstance("SHA2DRBG", this.jceProviderName);
                }
                catch (Exception e) {
                    throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.jvm_env_could_not_find_securerandom, (Object)("IBMSecureRandom/" + this.jceProviderName)));
                }
            }
            if (this.jceProviderName.compareToIgnoreCase(SUN_JCE_PROV) == 0) {
                try {
                    this.secureRandom = JcaFactory.getInstance(SecureRandom.class, "SHA1PRNG");
                }
                catch (Exception e) {
                    throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.jvm_env_could_not_find_securerandom, (Object)("SHA1PRNG/" + this.jceProviderName)));
                }
            }
            throw new CAMCryptoException(nsae, new Message(CamCryptoMessageKeys.jvm_env_could_not_find_securerandom, (Object)("SHA2DRBG/" + this.jceProviderName)));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.jvm_env_could_not_find_securerandom, (Object)this.jceProviderName));
        }
    }

    private void assertSetupCompleted() throws CAMCryptoException {
        this.completeSetup();
        if (!this.completedSetup) {
            throw new CAMCryptoException(new Message(CamCryptoMessageKeys.internal_error, (Object)"JVM environment information has been requested but its set up has not yet been fully completed."));
        }
    }

    @Override
    public String getJCEProvider() {
        return this.jceProviderName;
    }

    @Override
    public String getPBEProvider() {
        return this.pbeProviderName;
    }

    public String getJSSEProtocolName() throws CAMCryptoException {
        this.assertSetupCompleted();
        return this.jsseProtocolName;
    }

    @Override
    public SecureRandom getSecureRandom() throws CAMCryptoException {
        this.assertSetupCompleted();
        return this.secureRandom;
    }

    @Override
    public void addJCESecurityProvider() throws CAMCryptoException {
        try {
            Provider p;
            if (!JVMEnvironment.isProviderInstalled("SUN") && JVMEnvironment.canProviderClassBeFound("sun.security.provider.Sun")) {
                Class<?> sunClass = Class.forName("sun.security.provider.Sun");
                p = (Provider)sunClass.newInstance();
                Security.addProvider(p);
            }
            if (!JVMEnvironment.isProviderInstalled(this.jceProviderName)) {
                Class<?> jceClass = Class.forName(this.jceProviderClass);
                p = (Provider)jceClass.newInstance();
                Security.addProvider(p);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.jvm_env_could_not_add_jce));
        }
    }

    private static boolean canProviderClassBeFound(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isProviderInstalled(String providerName) {
        return Security.getProvider(providerName) != null;
    }

    @Override
    public boolean isIBMJava() {
        return isIBMJava;
    }

    public static float getJvmVersion() {
        String sVersion = System.getProperty("java.version");
        int secondDecimalPos = sVersion.indexOf(46, sVersion.indexOf(46) + 1);
        if (secondDecimalPos == -1) {
            secondDecimalPos = sVersion.indexOf(46) + 2;
        }
        float version = Float.parseFloat(sVersion.substring(0, secondDecimalPos));
        return version;
    }

    @Override
    public boolean isFIPSEnabled() {
        return this.isFIPSEnabled;
    }

    @Override
    public String getPKCS12KeystoreType() {
        if (this.isFIPSEnabled) {
            return PKCS12KEYSTORE_TYPE_FIPS;
        }
        return PKCS12KEYSTORE_TYPE;
    }
}

