/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.shared;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteOnCloseFileInputStream
extends FileInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteOnCloseFileInputStream.class);
    private File file;

    public DeleteOnCloseFileInputStream(String filename) throws FileNotFoundException {
        this(new File(filename));
    }

    public DeleteOnCloseFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.file = file;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.file != null) {
                if (!FileUtils.deleteQuietly((File)this.file)) {
                    LOGGER.trace("Delete file failed: {}", (Object)this.file.getAbsolutePath());
                }
                this.file = null;
            }
        }
    }
}

