/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.rest;

import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import com.ibm.bi.rest.RESTClientConfig;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTClient
implements Closeable {
    private static final String UTF_8 = "utf-8";
    private static Logger LOGGER = LoggerFactory.getLogger(RESTClient.class);
    protected CloseableHttpClient client;
    protected RESTClientConfig config;
    protected HttpClientContext context;
    protected CloseableHttpResponse response;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private JsonParser parser = null;
    private String trustToken;
    private static final Logger RESTCACHELOGGER = LoggerFactory.getLogger((String)"com.ibm.bi.rest.restCacheResponse");

    @Deprecated
    protected RESTClient(CloseableHttpClient client, RESTClientConfig config) {
        this(client, new HttpClientContext(), config);
    }

    protected RESTClient(CloseableHttpClient client, HttpClientContext context, RESTClientConfig config) {
        this.client = client;
        this.config = config;
        this.context = context;
    }

    protected URI buildURI(String path) throws URISyntaxException {
        if (path.startsWith("http")) {
            return new URI(path);
        }
        UriBuilder builder = UriBuilder.fromUri((URI)this.config.getBaseURI());
        int n = path.indexOf(63);
        if (n == -1) {
            builder.path(path);
        } else {
            builder.path(path.substring(0, n));
            builder.replaceQuery(path.substring(n + 1));
        }
        return builder.build(new Object[0]);
    }

    @Override
    public void close() throws IOException {
        this.prepareForNewRequest();
    }

    protected void prepareForNewRequest() {
        EntityUtils.consumeQuietly((HttpEntity)this.getEntity());
        IOUtils.closeQuietly((Closeable)this.response);
        this.response = null;
    }

    public int getResource(String path) throws IOException {
        HttpRequestBase method = this.createGetRequest(path);
        try {
            return this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public JsonObject getResponseAsJsonObject() throws IOException {
        InputStream response = this.getResponseStream();
        if (response != null) {
            return (JsonObject)this.getParser().parse(new InputStreamReader(response, UTF_8));
        }
        return null;
    }

    public JsonArray getResponseAsJsonArray() throws IOException {
        InputStream responseStream = this.getResponseStream();
        if (responseStream != null) {
            return (JsonArray)this.getParser().parse(new InputStreamReader(responseStream, UTF_8));
        }
        return null;
    }

    public JsonObject getResource(String path, String mediaType) throws IOException {
        JsonObject resource = null;
        try {
            resource = (JsonObject)this.getParser().parse(new InputStreamReader(this.getResourceAsStream(path, mediaType), UTF_8));
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return resource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject getResourceAsJson(String path, String mediaType) throws IOException {
        try (RESTClient restClient = this;){
            JsonObject jsonObject = (JsonObject)this.getParser().parse(new InputStreamReader(this.getResourceAsStream(path, mediaType), UTF_8));
            return jsonObject;
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
    }

    public JsonArray getResources(String path, String mediaType) throws IOException {
        JsonArray resources = null;
        try {
            resources = (JsonArray)this.getParser().parse(new InputStreamReader(this.getResourceAsStream(path, mediaType), UTF_8));
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return resources;
    }

    InputStream getResourceAsStream(String path, String mediaType) throws IOException {
        this.accept(mediaType);
        HttpRequestBase method = this.createGetRequest(path);
        this.executeMethod(method);
        return this.getResponseStream();
    }

    public InputStream getResourceStream(String path, String mediaType) throws IOException {
        InputStream is = null;
        try {
            is = this.getResourceAsStream(path, mediaType);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return is;
    }

    protected HttpEntity getEntity() {
        if (this.response == null) {
            return null;
        }
        HttpEntity respEntity = this.response.getEntity();
        if (respEntity == null) {
            return null;
        }
        Header[] encoding = this.response.getHeaders("Content-Encoding");
        if (encoding != null && encoding.length > 0 && encoding[0].getValue().equalsIgnoreCase("gzip")) {
            respEntity = new GzipDecompressingEntity(respEntity);
        }
        return respEntity;
    }

    public InputStream getResponseStream() throws IOException {
        InputStream in;
        HttpEntity entity = this.getEntity();
        if (entity != null && (in = entity.getContent()) != null && !(in instanceof EmptyInputStream)) {
            return in;
        }
        return null;
    }

    public String getMediaType() {
        Header[] headers;
        String mediaType = null;
        if (this.response != null && (headers = this.response.getHeaders("Content-Type")) != null && headers.length > 0) {
            mediaType = headers[0].getValue();
        }
        return mediaType;
    }

    public int createResource(String path, String mediaType, JsonObject model) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPostRequest(path, mediaType, model);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int createResource(String path, String mediaType, long length, InputStream stream) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPostRequest(path, mediaType, length, stream);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int createResource(String path, HttpEntity entity) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPostRequest(path, entity);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int updateResource(String path, String mediaType, JsonObject model) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPutRequest(path, mediaType, model);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int updateResource(String path, String mediaType, long length, InputStream stream) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPutRequest(path, mediaType, length, stream);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int updateResource(String path, HttpEntity entity) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPutRequest(path, entity);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int deleteResource(String path, String mediaType) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createDeleteRequest(path, mediaType);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public String getHeader(String name) {
        return this.responseHeaders.get(name.toLowerCase());
    }

    public String getResponseHeader(String name) {
        return this.responseHeaders.get(name.toLowerCase());
    }

    public Header[] getResponseHeaders() {
        if (this.response != null) {
            return this.response.getAllHeaders();
        }
        return null;
    }

    public void setRequestHeader(String name, String value) {
        this.config.setRequestHeader(name, value);
    }

    public void setPassportCookie(String passport) {
        this.config.setPassportCookie(passport);
    }

    public void clearRequestHeaders() {
        this.config.clearRequestHeaders();
    }

    public Collection<Header> getRequestHeaders() {
        return this.config.getRequestHeaders();
    }

    public JsonObject getErrorResponse() throws IOException {
        InputStream is = this.getErrorResponseStream();
        return is != null ? (JsonObject)this.getParser().parse(new InputStreamReader(is)) : null;
    }

    public InputStream getErrorResponseStream() throws IOException {
        Header[] contentType;
        if (this.response == null) {
            return null;
        }
        InputStream errorStream = null;
        if (this.response.getStatusLine().getStatusCode() >= 400 && (contentType = this.response.getHeaders("Content-Type")) != null && contentType.length > 0 && contentType[0].getValue().equalsIgnoreCase("application/json")) {
            errorStream = this.getResponseStream();
        }
        return errorStream;
    }

    public String getErrorResponseString() throws IOException {
        if (this.response == null) {
            return null;
        }
        if (this.response.getStatusLine().getStatusCode() >= 400) {
            return EntityUtils.toString((HttpEntity)this.getEntity());
        }
        return null;
    }

    protected JsonParser getParser() {
        if (this.parser == null) {
            this.parser = new JsonParser(DefaultJsonFactory.instance);
        }
        return this.parser;
    }

    protected void setHeaders(Header[] headers) {
        this.responseHeaders.clear();
        for (Header header : headers) {
            this.responseHeaders.put(header.getName().toLowerCase(), header.getValue());
        }
    }

    protected int executeMethod(HttpRequestBase method) throws IOException {
        return this.reallyExecuteMethod(method, true);
    }

    @Deprecated
    protected int executeMethod(HttpRequestBase method, boolean throwOnError) throws IOException {
        try {
            return this.reallyExecuteMethod(method, throwOnError);
        }
        catch (IOException iox) {
            LOGGER.info("IOException \"{}\" executing {} to {} by {}", new Object[]{iox.getMessage(), method.getClass().getSimpleName(), method.getURI().toString(), this.config.getContext()});
            throw iox;
        }
    }

    protected int reallyExecuteMethod(HttpRequestBase method, boolean throwOnError) throws IOException {
        this.prepareForNewRequest();
        this.response = this.client.execute((HttpUriRequest)method, (HttpContext)this.context);
        this.logCacheResponse(method, this.context);
        int statusCode = this.response.getStatusLine().getStatusCode();
        if (throwOnError && statusCode >= 400) {
            throw new RuntimeException(String.format("[%d] %s", statusCode, this.response.getStatusLine().getReasonPhrase()));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Executed {} to {} by {}", new Object[]{method.getClass().getSimpleName(), method.getURI().toString(), this.config.getContext()});
        }
        this.setHeaders(this.response.getAllHeaders());
        return statusCode;
    }

    private void logCacheResponse(HttpRequestBase method, HttpClientContext clientContext) {
        Logger localLogger;
        String ctx = this.config.getContext();
        Logger logger = localLogger = RESTCACHELOGGER.isDebugEnabled() ? RESTCACHELOGGER : LoggerFactory.getLogger((String)("com.ibm.bi.rest.restCacheResponse." + ctx));
        if (localLogger.isDebugEnabled() && clientContext instanceof HttpCacheContext) {
            URI uri = method.getURI();
            StringBuilder url = new StringBuilder(uri.getPath());
            String qs = uri.getQuery();
            if (StringUtils.isNotEmpty((String)qs)) {
                url.append("?").append(qs);
            }
            CacheResponseStatus responseStatus = ((HttpCacheContext)clientContext).getCacheResponseStatus();
            switch (responseStatus) {
                case CACHE_HIT: {
                    localLogger.debug("{}: {} cache hit, not validated", (Object)ctx, (Object)url.toString());
                    break;
                }
                case CACHE_MODULE_RESPONSE: {
                    localLogger.debug("{}: {} caching module", (Object)ctx, (Object)url.toString());
                    break;
                }
                case CACHE_MISS: {
                    localLogger.debug("{}: {} cache miss", (Object)ctx, (Object)url.toString());
                    break;
                }
                case VALIDATED: {
                    localLogger.debug("{}: {} cache hit, validated with the origin server", (Object)ctx, (Object)url.toString());
                }
            }
        }
    }

    protected void setupMethod(HttpRequestBase method, String path) {
        try {
            method.setURI(this.buildURI(path));
            this.copyRequestHeaders(method);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void copyRequestHeaders(HttpRequestBase method) {
        for (Header header : this.getRequestHeaders()) {
            method.addHeader(header);
        }
    }

    protected HttpRequestBase createGetRequest(String path) {
        HttpGet httpGet = new HttpGet();
        this.setupMethod((HttpRequestBase)httpGet, path);
        return httpGet;
    }

    protected HttpRequestBase createHeadRequest(String path) {
        HttpHead httpHead = new HttpHead();
        this.setupMethod((HttpRequestBase)httpHead, path);
        return httpHead;
    }

    protected HttpRequestBase createPostRequest(String path, String mediaType, JsonObject resource) {
        byte[] body = resource.toString().getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream is = new ByteArrayInputStream(body);
        return this.createPostRequest(path, mediaType, body.length, is);
    }

    protected HttpRequestBase createPostRequest(String path, String mediaType, long length, InputStream stream) {
        InputStreamEntity entity = length != -1L ? new InputStreamEntity(stream, length, ContentType.parse((String)mediaType)) : new InputStreamEntity(stream, ContentType.parse((String)mediaType));
        return this.createPostRequest(path, (HttpEntity)entity);
    }

    protected HttpRequestBase createPostRequest(String path, HttpEntity entity) {
        HttpPost httpPost = new HttpPost();
        this.setupMethod((HttpRequestBase)httpPost, path);
        httpPost.setEntity(entity);
        return httpPost;
    }

    protected HttpRequestBase createPutRequest(String path, String mediaType, JsonObject resource) {
        byte[] body = resource.toString().getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream is = new ByteArrayInputStream(body);
        this.accept(mediaType);
        return this.createPutRequest(path, mediaType, body.length, is);
    }

    protected HttpRequestBase createPutRequest(String path, String mediaType, long length, InputStream stream) {
        InputStreamEntity entity = length != -1L ? new InputStreamEntity(stream, length, ContentType.parse((String)mediaType)) : new InputStreamEntity(stream, ContentType.parse((String)mediaType));
        return this.createPutRequest(path, (HttpEntity)entity);
    }

    protected HttpRequestBase createPutRequest(String path, HttpEntity entity) {
        HttpPut httpPut = new HttpPut();
        this.setupMethod((HttpRequestBase)httpPut, path);
        httpPut.setEntity(entity);
        return httpPut;
    }

    protected HttpRequestBase createDeleteRequest(String path, String mediaType) {
        this.accept(mediaType);
        return this.createDeleteRequest(path);
    }

    protected HttpRequestBase createDeleteRequest(String path) {
        HttpDelete httpDelete = new HttpDelete();
        this.setupMethod((HttpRequestBase)httpDelete, path);
        return httpDelete;
    }

    protected HttpRequestBase createPatchRequest(String path, HttpEntity entity) {
        HttpPatch httpPatch = new HttpPatch();
        this.setupMethod((HttpRequestBase)httpPatch, path);
        httpPatch.setEntity(entity);
        return httpPatch;
    }

    public void accept(String mediaType) {
        if (StringUtils.isNotEmpty((String)mediaType)) {
            this.setRequestHeader("Accept", mediaType);
        }
    }

    @Deprecated
    public boolean hasResponseBody() {
        return true;
    }

    Header getFirstHeader(String name) {
        return this.response != null ? this.response.getFirstHeader(name) : null;
    }

    public int getResponseCode() {
        if (this.response == null) {
            return 500;
        }
        return this.response.getStatusLine().getStatusCode();
    }

    public boolean makeTrusted(String serviceID) {
        String jcamCryptoClassPath = "com.ibm.bi.platform.commons.crypto.JCAMCrypto";
        Class<?> jcamCryptoClass = null;
        try {
            jcamCryptoClass = Class.forName("com.ibm.bi.platform.commons.crypto.JCAMCrypto");
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Failed to get JCAMCrypto class: {}", (Object)e.getLocalizedMessage());
            return false;
        }
        Class<?> trustedRequestSessionClass = null;
        try {
            Method method = jcamCryptoClass.getMethod("createTrustedRequestSession", null);
            Object trustedRequestSession = method.invoke(null, (Object[])null);
            trustedRequestSessionClass = trustedRequestSession.getClass();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Failed to get JCAMCrypto TrustedRequestSession class: {}", (Object)e.getLocalizedMessage());
            return false;
        }
        try {
            Object trustedRequestSession = trustedRequestSessionClass.newInstance();
            Method method = trustedRequestSessionClass.getMethod("generateToken", String.class);
            this.trustToken = (String)method.invoke(trustedRequestSession, serviceID);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Failed to call JCAMCryoto token method: {}", (Object)e.getLocalizedMessage());
            return false;
        }
        this.setRequestHeader("X-CA-Authorization", this.trustToken);
        return true;
    }

    protected String getTrustToken() {
        return this.trustToken;
    }

    public boolean isCachedResponse() {
        if (this.context instanceof HttpCacheContext) {
            HttpCacheContext cacheContext = (HttpCacheContext)this.context;
            CacheResponseStatus status = cacheContext.getCacheResponseStatus();
            switch (status) {
                case CACHE_HIT: 
                case CACHE_MODULE_RESPONSE: 
                case VALIDATED: {
                    return true;
                }
                case CACHE_MISS: {
                    return false;
                }
            }
        }
        return false;
    }
}

