/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.crypto.utilities;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.ibm.bi.soap.services.SoapContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedContext
extends SoapContext {
    private static final String ADM_DS_REST = "ADM-DS-REST";
    private String trustedService;
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustedContext.class);

    public TrustedContext(HttpServletRequest request, String service) {
        super(request);
        this.trustedService = service != null ? service : ADM_DS_REST;
    }

    public boolean isTrusted() {
        return true;
    }

    public byte[] setMessageTrust(byte[] request) {
        try {
            CAMFactory factory = new CAMFactory(this.trustedService);
            TrustedRequestSession session = factory.createTrustedSession();
            return session.setMessageTrust(this.trustedService, request);
        }
        catch (CAMCryptoException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return request;
        }
    }
}

