/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external.flipper;

import com.ibm.bi.config.external.ReadOnlyConfigurationWrapper;
import com.netflix.config.ConcurrentCompositeConfiguration;
import java.lang.reflect.Field;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHolder
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigHolder.class);
    private AbstractConfiguration rawConfig;
    private AbstractConfiguration readOnlyConfig;

    ConfigHolder(AbstractConfiguration rawConfig) {
        this.rawConfig = rawConfig;
        this.readOnlyConfig = new ReadOnlyConfigurationWrapper((Configuration)rawConfig);
    }

    protected ConfigHolder() {
    }

    public AbstractConfiguration getConfig() {
        return this.readOnlyConfig;
    }

    @Override
    public void close() {
        if (this.rawConfig instanceof ConcurrentCompositeConfiguration) {
            ConcurrentCompositeConfiguration ccc = (ConcurrentCompositeConfiguration)this.rawConfig;
            ConfigurationListener listener = ConfigHolder.configurationListenerOf(ccc);
            for (AbstractConfiguration ac : ccc.getConfigurations()) {
                ac.removeConfigurationListener(listener);
            }
        }
        this.rawConfig.clear();
    }

    static ConfigurationListener configurationListenerOf(ConcurrentCompositeConfiguration ccc) {
        try {
            Field field = ccc.getClass().getDeclaredField("eventPropagater");
            field.setAccessible(true);
            return (ConfigurationListener)field.get(ccc);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOG.error("failed to access field eventPropagater of ConcurrentCompositeConfiguration by reflection.", (Throwable)e);
            return null;
        }
    }
}

