/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external.flipper;

import com.ibm.bi.config.external.flipper.ConfigHolder;
import com.ibm.bi.config.external.flipper.FlipperRestInterface;
import com.ibm.bi.config.util.PropertiesConfigurationFactory;
import com.netflix.config.ConcurrentCompositeConfiguration;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;

public class LiveProperties {
    private FlipperRestInterface flipperRest;

    public LiveProperties(FlipperRestInterface flipperRest) {
        this.flipperRest = flipperRest;
    }

    public ConfigHolder getMergedView(String path, int numLayers) {
        PropertiesConfiguration view;
        if (numLayers == 1) {
            view = this.getConfigurationForPath(path, 0);
            if (view == null) {
                view = PropertiesConfigurationFactory.make();
            }
        } else {
            ConcurrentCompositeConfiguration compositeConfig = new ConcurrentCompositeConfiguration();
            for (int layer = 0; layer < numLayers; ++layer) {
                PropertiesConfiguration layerProps = this.getConfigurationForPath(path, layer);
                if (layerProps == null) {
                    layerProps = PropertiesConfigurationFactory.make();
                }
                compositeConfig.addConfiguration((AbstractConfiguration)layerProps);
            }
            view = compositeConfig;
        }
        return new ConfigHolder((AbstractConfiguration)view);
    }

    PropertiesConfiguration getConfigurationForPath(String path, int layer) {
        return this.flipperRest.getConfiguration(this.buildFullPath(path, layer));
    }

    private String buildFullPath(String path, int layer) {
        return path + "/configuration" + layer + ".properties";
    }

    public PropertiesConfiguration getView(String path, int layer) {
        return this.getConfigurationForPath(path, layer);
    }

    public void update(Configuration settings, String path, int layer) throws Exception {
        String fullPath = this.buildFullPath(path, layer);
        this.updateStore(settings, fullPath);
    }

    public void updateStore(Configuration settings, String fullPath) throws Exception {
        PropertiesConfiguration current = this.flipperRest.getConfiguration(fullPath);
        if (current == null) {
            current = PropertiesConfigurationFactory.make();
        }
        current.copy(settings);
        this.flipperRest.store(fullPath, current);
    }

    public void replace(Configuration settings, String path, int layer) throws Exception {
        String fullPath = this.buildFullPath(path, layer);
        PropertiesConfiguration newSettings = PropertiesConfigurationFactory.make();
        newSettings.copy(settings);
        this.flipperRest.store(fullPath, newSettings);
    }

    public void deletekey(String path, String key, int layer) throws Exception {
        String fullPath = this.buildFullPath(path, layer);
        PropertiesConfiguration current = this.flipperRest.getConfiguration(fullPath);
        if (current == null) {
            return;
        }
        current.clearProperty(key);
        this.flipperRest.store(fullPath, current);
    }
}

