/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.commons.lang.StringUtils;

public class CheckedFileOutputStream
extends OutputStream {
    public static final int HDRSIZE = 128;
    static final String CRC32 = "{crc32}";
    private RandomAccessFile raOut;
    private CheckedOutputStream chkOut;

    public CheckedFileOutputStream(File file) throws IOException {
        this.raOut = new RandomAccessFile(file, "rw");
        this.raOut.seek(128L);
        this.chkOut = new CheckedOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                CheckedFileOutputStream.this.raOut.write(b);
            }
        }, new CRC32());
    }

    @Override
    public void write(int b) throws IOException {
        this.chkOut.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.chkOut.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.chkOut.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.chkOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.chkOut.close();
        long sum = this.chkOut.getChecksum().getValue();
        this.raOut.seek(0L);
        this.raOut.write(CheckedFileOutputStream.makeHeader(sum));
        this.raOut.close();
    }

    public static byte[] makeHeader(long checksum) {
        return StringUtils.rightPad((String)(CRC32 + Long.toString(checksum)), (int)128).getBytes();
    }
}

