/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.flipper.auth;

import com.google.common.net.MediaType;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityChecker {
    private static final Logger LOG = LoggerFactory.getLogger(CapabilityChecker.class);
    private final Supplier<RESTClientFactory> restClientFactorySupplier;

    CapabilityChecker(Supplier<RESTClientFactory> restClientFactorySupplier) {
        this.restClientFactorySupplier = restClientFactorySupplier;
    }

    public CapabilityChecker() {
        this.restClientFactorySupplier = () -> RESTClientFactory.getInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasAnyCapability(HttpServletRequest servletRequest, String ... capabilities) {
        boolean isCapable = false;
        if (Boolean.getBoolean("ignore-user-identity")) {
            return true;
        }
        try (RESTClient client = this.restClientFactorySupplier.get().getClient(servletRequest);){
            JsonObject obj = client.getResource("/bi/v1/users/~/capabilities", MediaType.JSON_UTF_8.toString());
            if (obj == null) return isCapable;
            boolean bl = CapabilityChecker.isUserCapable(obj, capabilities);
            return bl;
        }
        catch (IOException e) {
            LOG.debug("Current user is not a System Administration. ", (Throwable)e);
            return false;
        }
    }

    static boolean isUserCapable(JsonObject obj, String ... capabilities) {
        boolean isCapable = false;
        try {
            JsonArray capabilitiesList = obj.getArray("userCapabilities");
            block2: for (Object o : capabilitiesList) {
                for (String str : capabilities) {
                    if (!o.equals(str)) continue;
                    isCapable = true;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            LOG.debug("the user is not system administrator", (Throwable)e);
            return false;
        }
        return isCapable;
    }
}

