/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.support.web;

import com.ibm.bi.logging.glug.support.BITransactionHeader;
import com.ibm.bi.logging.glug.support.web.GlugLoggingContext;
import com.ibm.bi.logging.glug.support.web.P2PDRequestWrapper;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

@WebFilter(urlPatterns={"/*"}, dispatcherTypes={DispatcherType.REQUEST})
public class BITransactionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BITransactionFilter.class);

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        P2PDRequestWrapper requestWrapper = new P2PDRequestWrapper((HttpServletRequest)request);
        MDCAdapter mdc = MDC.getMDCAdapter();
        mdc.clear();
        try {
            this.addTransactionHeaderToMDC(mdc, requestWrapper);
            GlugLoggingContext.setupContext((HttpServletRequest)requestWrapper, mdc);
            chain.doFilter((ServletRequest)requestWrapper, response);
        }
        finally {
            mdc.clear();
        }
    }

    private void addTransactionHeaderToMDC(MDCAdapter mdc, P2PDRequestWrapper req) {
        BITransactionHeader header = req.getTransactionHeader();
        for (HeaderElement element : header.getElements()) {
            mdc.put(element.getName(), element.getValue());
        }
    }

    public void init(FilterConfig fConfig) throws ServletException {
        LOGGER.debug("BITransactionFilter initialized in {}", (Object)fConfig.getServletContext().getContextPath());
    }
}

