/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.support.web;

import com.ibm.bi.logging.glug.support.BITransactionHeader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;

public class P2PDRequestWrapper
extends HttpServletRequestWrapper {
    private final BITransactionHeader transactionHeader;

    public P2PDRequestWrapper(HttpServletRequest request) {
        super(request);
        this.transactionHeader = new BITransactionHeader(this.getIncomingValue(request));
    }

    String getIncomingValue(HttpServletRequest request) {
        Cookie[] cookies;
        String incomingValue = request.getHeader("X-CA-Transaction");
        if (StringUtils.isEmpty((String)incomingValue) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!"CATransaction".equalsIgnoreCase(cookie.getName())) continue;
                try {
                    incomingValue = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return incomingValue;
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = this.getCookiesFromRequest();
        String transactionCookieValue = this.getTransactionCookieValue();
        if (transactionCookieValue == null) {
            return cookies;
        }
        boolean transactionCookieFound = false;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!"CATransaction".equalsIgnoreCase(cookie.getName())) continue;
                transactionCookieFound = true;
                cookie.setValue(transactionCookieValue);
            }
            if (!transactionCookieFound) {
                Cookie[] extendedCookies = Arrays.copyOf(cookies, cookies.length + 1);
                extendedCookies[cookies.length] = new Cookie("CATransaction", transactionCookieValue);
                return extendedCookies;
            }
        } else {
            cookies = new Cookie[]{new Cookie("CATransaction", transactionCookieValue)};
        }
        return cookies;
    }

    protected Cookie[] getCookiesFromRequest() {
        return super.getCookies();
    }

    private String getTransactionCookieValue() {
        try {
            return URLEncoder.encode(this.transactionHeader.getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getHeader(String name) {
        if ("X-CA-Transaction".equalsIgnoreCase(name)) {
            return this.transactionHeader.getValue();
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if ("X-CA-Transaction".equalsIgnoreCase(name)) {
            return Collections.enumeration(Arrays.asList(this.getHeader(name)));
        }
        return super.getHeaders(name);
    }

    public BITransactionHeader getTransactionHeader() {
        return this.transactionHeader;
    }
}

