/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json;

import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonFactory;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class JsonParser {
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final int LONG_MAX_VALUE_LENGTH = String.valueOf(Long.MAX_VALUE).length();
    protected Reader in;
    protected char[] buf;
    protected int limit;
    protected int off;
    protected JsonFactory factory;
    int buffer_size = 4096;
    int lineNo;
    int line_start;
    int line_len;
    private int lineNo_saved;
    private int line_start_saved;
    private int line_len_saved;
    private int off_saved;

    public JsonParser() {
        this(DefaultJsonFactory.instance);
    }

    public JsonParser(JsonFactory factory) {
        this.factory = factory;
    }

    public Object parse(Reader r) throws IOException {
        if (!this.reset(r)) {
            return null;
        }
        Object result = this.parseAny();
        --this.off;
        char ch = this.nextToken();
        if (ch != '\uffff') {
            this.throwUnexpectedCharacter(ch);
        }
        return result;
    }

    protected Object parseAny() throws IOException {
        char ch = this.buf[this.off];
        if (ch == '-' || ch >= '0' && ch <= '9') {
            return this.parseNumber();
        }
        switch (ch) {
            case '{': {
                return this.parseObject();
            }
            case '[': {
                return this.parseArray();
            }
            case '\"': {
                return this.parseString('\"');
            }
            case 'n': {
                this.parseToken("null");
                return this.factory.createNull();
            }
            case 't': {
                this.parseToken("true");
                return this.factory.createBoolean(true);
            }
            case 'f': {
                this.parseToken("false");
                return this.factory.createBoolean(false);
            }
        }
        this.throwUnexpectedCharacter(ch);
        return null;
    }

    protected Object parseNumber() throws IOException {
        this.savePosition();
        boolean isDouble = false;
        StringBuilder b = new StringBuilder();
        int start = this.off++;
        while (true) {
            if (this.off < this.limit) {
                char ch = this.buf[this.off];
                if (ch == '.' || ch == 'e' || ch == 'E') {
                    isDouble = true;
                }
                if ((ch < '0' || ch > '9') && ch != 'e' && ch != 'E' && ch != '.' && ch != '+' && ch != '-') break;
                ++this.off;
                continue;
            }
            if (start != this.off) {
                b.append(this.buf, start, this.off - start);
            }
            this.off = 0;
            start = 0;
            this.limit = this.in.read(this.buf, 0, this.buf.length);
            if (this.limit == -1) break;
        }
        if (start != this.off) {
            b.append(this.buf, start, this.off - start);
        }
        String s = b.toString();
        try {
            return isDouble ? this.makeDouble(s) : this.makeInteger(s);
        }
        catch (NumberFormatException e) {
            this.restorePosition();
            throw new IOException("invalid number '" + s + "'" + this.position(), e);
        }
    }

    private Object makeInteger(String s) {
        if (s.length() < LONG_MAX_VALUE_LENGTH) {
            return this.factory.createLong(Long.parseLong(s));
        }
        BigInteger bi = new BigInteger(s);
        if (s.length() > LONG_MAX_VALUE_LENGTH || bi.compareTo(MAX_LONG) > 0) {
            return this.factory.createBigInteger(bi);
        }
        return this.factory.createLong(bi.longValue());
    }

    private Object makeDouble(String s) {
        double d = Double.parseDouble(s);
        if (d != 0.0 && !Double.isNaN(d) && !Double.isInfinite(d)) {
            return d;
        }
        BigDecimal bigD = new BigDecimal(s);
        return bigD.compareTo(BigDecimal.ZERO) == 0 ? Double.valueOf(0.0) : bigD;
    }

    protected void parseToken(String str) throws IOException {
        int i = 0;
        int len = str.length();
        while (i < len) {
            char ch;
            if (this.off >= this.limit) {
                this.off = 0;
                this.limit = this.in.read(this.buf, 0, this.buf.length);
                if (this.limit != -1) continue;
                throw new IOException("unexpected end of file");
            }
            if ((ch = this.buf[this.off++]) == str.charAt(i++)) continue;
            this.throwUnexpectedCharacter(ch);
        }
    }

    protected Object parseString(char quote) throws IOException {
        StringBuilder bld = new StringBuilder();
        boolean escape = false;
        ++this.off;
        int start = this.off;
        boolean cr = false;
        while (true) {
            if (this.off < this.limit) {
                if (escape) {
                    bld.append(this.parseEscapeChar());
                    escape = false;
                    start = this.off + 1;
                } else {
                    char ch = this.buf[this.off];
                    if (ch == '\\') {
                        if (start != this.off) {
                            bld.append(this.buf, start, this.off - start);
                        }
                        escape = true;
                    } else {
                        if (ch == quote) {
                            if (start < this.off) {
                                bld.append(this.buf, start, this.off - start);
                            }
                            ++this.off;
                            return this.factory.createString(bld.toString());
                        }
                        if (ch == '\r') {
                            if (this.off == this.limit - 1) {
                                cr = true;
                            }
                            ++this.lineNo;
                            this.line_start = this.off + 1;
                            this.line_len = 0;
                        } else if (ch == '\n') {
                            if (cr) {
                                cr = false;
                                ++this.line_start;
                            } else if (this.off != 0 && this.buf[this.off - 1] == '\r') {
                                ++this.line_start;
                            } else {
                                ++this.lineNo;
                                this.line_start = this.off + 1;
                                this.line_len = 0;
                            }
                        }
                    }
                }
                ++this.off;
                continue;
            }
            if (start < this.off && !escape) {
                bld.append(this.buf, start, this.off - start);
            }
            this.line_len += this.off - this.line_start;
            this.line_start = 0;
            start = 0;
            this.off = 0;
            this.limit = this.in.read(this.buf, 0, this.buf.length);
            if (this.limit == -1) break;
        }
        throw new IOException("unexpected end of file");
    }

    private char parseEscapeChar() throws IOException {
        char ch = this.buf[this.off];
        switch (ch) {
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case '/': {
                return '/';
            }
            case 'r': {
                return '\r';
            }
            case 'u': {
                ++this.off;
                return this.parseUnicode();
            }
        }
        throw new IOException("invalid escape sequence: \\" + ch + this.position());
    }

    private char parseUnicode() throws IOException {
        int result = 0;
        int n = 4;
        while (n != 0) {
            int ch;
            if (this.off >= this.limit) {
                this.off = 0;
                this.limit = this.in.read(this.buf, 0, this.buf.length);
                if (this.limit != -1) continue;
                throw new IOException("unexpected end of file");
            }
            if ((ch = this.buf[this.off++]) >= 97 && ch <= 102) {
                ch = ch - 97 + 10;
            } else if (ch >= 65 && ch <= 70) {
                ch = ch - 65 + 10;
            } else if (ch >= 48 && ch <= 57) {
                ch -= 48;
            } else {
                this.throwUnexpectedCharacter((char)ch);
            }
            result *= 16;
            result += ch;
            --n;
        }
        --this.off;
        return (char)result;
    }

    protected Object parseObject() throws IOException {
        Map map = this.factory.createObject();
        if (this.expect('}', '\"') == '}') {
            ++this.off;
            return map;
        }
        while (true) {
            Object key = this.parseString('\"');
            --this.off;
            this.expect(':');
            this.nextToken();
            Object value = this.parseAny();
            map.put(key, value);
            --this.off;
            if (this.expect('}', ',') == '}') {
                ++this.off;
                return map;
            }
            this.expect('\"');
        }
    }

    protected char expect(char expected) throws IOException {
        char ch = this.nextToken();
        if (ch != expected) {
            this.throwUnexpectedCharacter(ch);
        }
        return ch;
    }

    protected char expect(char ... expected) throws IOException {
        char actual = this.nextToken();
        boolean found = false;
        for (char ch : expected) {
            found |= actual == ch;
        }
        if (!found) {
            this.throwUnexpectedCharacter(actual);
        }
        return actual;
    }

    protected void throwUnexpectedCharacter(char actual) throws IOException {
        StringBuilder b = new StringBuilder();
        if (actual == '\uffff') {
            throw new IOException("unexpected end of file");
        }
        b.append("unexpected character '").append(actual).append("'").append(this.position());
        throw new IOException(b.toString());
    }

    protected Object parseArray() throws IOException {
        List array = this.factory.createArray();
        char ch = this.nextToken();
        if (ch == ']') {
            ++this.off;
            return array;
        }
        while (true) {
            Object value = this.parseAny();
            array.add(value);
            --this.off;
            if (this.expect(']', ',') == ']') {
                ++this.off;
                return array;
            }
            this.nextToken();
        }
    }

    protected boolean reset(Reader r) throws IOException {
        this.in = r;
        if (this.buf == null || this.buf.length != this.buffer_size) {
            this.buf = new char[this.buffer_size];
        }
        this.lineNo = 1;
        this.line_start = 0;
        this.off = 0;
        this.limit = 0;
        return this.nextToken() != '\uffff';
    }

    protected char nextToken() throws IOException {
        ++this.off;
        boolean cr = false;
        while (true) {
            if (this.off < this.limit) {
                char ch = this.buf[this.off];
                if (ch == '\r') {
                    if (this.off == this.limit - 1) {
                        cr = true;
                    }
                    ++this.lineNo;
                    this.line_start = this.off + 1;
                    this.line_len = 0;
                } else if (ch == '\n') {
                    if (cr) {
                        cr = false;
                        ++this.line_start;
                    } else if (this.off != 0 && this.buf[this.off - 1] == '\r') {
                        ++this.line_start;
                    } else {
                        ++this.lineNo;
                        this.line_start = this.off + 1;
                        this.line_len = 0;
                    }
                } else if (ch != '\t' && ch != ' ') {
                    return this.buf[this.off];
                }
                ++this.off;
                continue;
            }
            this.line_len += this.off - this.line_start;
            this.line_start = 0;
            this.off = 0;
            this.limit = this.in.read(this.buf, 0, this.buf.length);
            if (this.limit == -1) break;
        }
        return '\uffff';
    }

    private void savePosition() {
        this.line_len_saved = this.line_len;
        this.line_start_saved = this.line_start;
        this.lineNo_saved = this.lineNo;
        this.off_saved = this.off;
    }

    private void restorePosition() {
        this.line_len = this.line_len_saved;
        this.line_start = this.line_start_saved;
        this.lineNo = this.lineNo_saved;
        this.off = this.off_saved;
    }

    private String position() {
        StringBuilder temp = new StringBuilder();
        temp.append(" at line ").append(this.lineNo);
        temp.append(", column ").append(this.line_len + this.off - this.line_start + 1);
        return temp.toString();
    }
}

