/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.key;

import com.ibm.bi.platform.commons.crypto.internal.key.UnixCryptoByteBuffer;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import java.security.MessageDigest;
import java.util.Arrays;

public final class LinuxCryptoByteBuffer
extends UnixCryptoByteBuffer {
    @Override
    public byte[] getByteBuffer2(int param) {
        byte[] result = null;
        String computerInfo = UnixCryptoByteBuffer.getNodename();
        try {
            MessageDigest md = JcaFactory.getInstance(MessageDigest.class, "MD5");
            result = md.digest(computerInfo.getBytes());
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new RuntimeException("getByteBuffer2: Cannot find MD5 message digest", e);
        }
        return result;
    }

    @Override
    public byte[] getByteBuffer3(int param) {
        byte[] result = null;
        String computerInfo = UnixCryptoByteBuffer.getMachine() + UnixCryptoByteBuffer.getSysname() + UnixCryptoByteBuffer.getNodename();
        try {
            MessageDigest md = JcaFactory.getInstance(MessageDigest.class, "SHA-256");
            result = md.digest(computerInfo.getBytes());
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new RuntimeException("getByteBuffer3: Cannot find SHA-256 message digest", e);
        }
        return Arrays.copyOfRange(result, 0, 16);
    }
}

