/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.key;

import com.ibm.bi.platform.commons.crypto.internal.key.CryptoByteBuffer;
import com.ibm.bi.platform.commons.crypto.internal.key.UnixCryptoByteBuffer;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;

public class SolarisCryptoByteBuffer
extends UnixCryptoByteBuffer {
    @Override
    public byte[] getByteBuffer2(int param) {
        byte[] result = null;
        String computerInfo = SolarisCryptoByteBuffer.getHwSerial();
        try {
            MessageDigest md = JcaFactory.getInstance(MessageDigest.class, "MD5");
            result = md.digest(computerInfo.getBytes());
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new RuntimeException("getByteBuffer2: Cannot find MD5 message digest", e);
        }
        return result;
    }

    @Override
    public byte[] getByteBuffer3(int param) {
        byte[] result = null;
        String computerInfo = UnixCryptoByteBuffer.getSysname() + UnixCryptoByteBuffer.getNodename() + SolarisCryptoByteBuffer.getHwSerial();
        try {
            MessageDigest md = JcaFactory.getInstance(MessageDigest.class, "SHA-256");
            result = md.digest(computerInfo.getBytes());
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new RuntimeException("getByteBuffer3: Cannot find SHA-256 message digest", e);
        }
        return Arrays.copyOfRange(result, 0, 16);
    }

    private static String getHwSerial() {
        List<String> command = Arrays.asList("hostid");
        String hostIdAsHex = CryptoByteBuffer.executeAndGetCommandOutput(command);
        return SolarisCryptoByteBuffer.convertHexStringToDecString(hostIdAsHex);
    }

    private static String convertHexStringToDecString(String hostIdAsHex) {
        long hostId = Long.parseLong(hostIdAsHex, 16);
        return Long.toString(hostId);
    }
}

