/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.keystore;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfiguration;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMCskJceks;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMCskPkcs12;
import com.ibm.bi.platform.commons.crypto.internal.session.SystemKeyCryptoSession;
import com.ibm.bi.platform.commons.crypto.internal.utils.CAMConfiguration;
import com.ibm.bi.platform.commons.crypto.internal.utils.CAMLockFile;
import com.ibm.bi.platform.commons.crypto.internal.utils.JVMEnvironment;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CAMCskKs {
    private static final Logger LOGGER = LoggerFactory.getLogger(CAMCskKs.class);
    public static final String JCEKS_KEYSTORE_TYPE = "JCEKS_KEYSTORE_TYPE";
    public static final String PKCS12_KEYSTORE_TYPE = "PKCS12_KEYSTORE_TYPE";
    static final String CURRENT_CSK_ALIAS = "csk";
    private static CAMCskKs instance;
    private static final Object testLock;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private String ksLockFilename;
    private String bksFilename;
    private KeyStore bks;
    private CAMLockFile ksLock;
    String ksFilename;
    String ksPassword;
    boolean ksPasswordEnc;
    private RESTClientFactory rcFactory;
    private byte[] currentCSKAlias;
    private boolean needToUpdateCurrentCSKAlias = true;

    private static void createInstance(String keystoreType) throws CAMCryptoException {
        if (JCEKS_KEYSTORE_TYPE.equals(keystoreType)) {
            instance = new CAMCskJceks();
        } else if (PKCS12_KEYSTORE_TYPE.equals(keystoreType)) {
            instance = new CAMCskPkcs12();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CAMCskKs getInstance() throws CAMCryptoException {
        if (instance != null) return instance;
        Class<CAMCskKs> clazz = CAMCskKs.class;
        synchronized (CAMCskKs.class) {
            if (instance != null) return instance;
            String keystoreType = CAMConfiguration.getInstance().getCSKKeystoreType();
            CAMCskKs.createInstance(keystoreType);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInstance(CAMCskKs anInstance) throws InterruptedException {
        Object object = testLock;
        synchronized (object) {
            if (instance != null) {
                testLock.wait();
            }
            instance = anInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroyInstance() {
        Object object = testLock;
        synchronized (object) {
            if (instance != null) {
                instance = null;
                testLock.notify();
            }
        }
    }

    private boolean checkIfCurrentCSKMatchesAlias(byte[] keyAlias) throws CAMCryptoException {
        return Arrays.equals(keyAlias, this.getCurrentCSKAlias());
    }

    void commonInit(String keystoreType) throws CAMCryptoException {
        this.bksFilename = this.ksFilename + ".bks";
        this.ksLockFilename = this.ksFilename + ".lock";
        try {
            this.bks = JcaFactory.getInstance(KeyStore.class, "BKS");
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_get_keystore_instance, (Object)keystoreType));
        }
        this.load();
        this.rcFactory = RESTClientFactory.getInstance();
        this.rcFactory.startup();
    }

    private String decryptPasswordIfReq() throws CAMCryptoException {
        String decPassword = null;
        if (this.ksPasswordEnc) {
            byte[] decBytes = SystemKeyCryptoSession.decryptData(this.ksPassword.getBytes(), JVMEnvironment.getInstance());
            try {
                decPassword = new String(decBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.sys_prot_key_decrypt_failure));
            }
        } else {
            decPassword = this.ksPassword;
        }
        return decPassword;
    }

    public SecretKey getCSK() throws CAMCryptoException {
        SecretKey theKey = this.getCSKNotSynchronized(CURRENT_CSK_ALIAS);
        return theKey;
    }

    public SecretKey getCSK(byte[] keyAlias) throws CAMCryptoException {
        SecretKey theKey = null;
        if (this.checkIfCurrentCSKMatchesAlias(keyAlias)) {
            theKey = this.getCSKNotSynchronized(CURRENT_CSK_ALIAS);
        }
        if (theKey != null) {
            return theKey;
        }
        String encodedKeyAlias = null;
        String encodedLowerCaseKeyAlias = null;
        try {
            encodedKeyAlias = new String(Base64.encodeBase64((byte[])keyAlias), "UTF-8");
            if (encodedKeyAlias != null) {
                encodedLowerCaseKeyAlias = encodedKeyAlias.toLowerCase();
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.trace("getCSK: could not convert base64 encoded alias to UTF-8 " + e.toString());
        }
        if (encodedLowerCaseKeyAlias != null) {
            theKey = this.getCSKNotSynchronized(encodedLowerCaseKeyAlias);
        }
        if (theKey == null && encodedLowerCaseKeyAlias != null) {
            this.callKeySyncService(encodedKeyAlias);
            this.load();
            theKey = this.getCSKNotSynchronized(encodedLowerCaseKeyAlias);
        }
        return theKey;
    }

    private void callKeySyncService(String encodedKeyAlias) {
        String dispUrl = JCAMCryptoConfiguration.getProvider().getInternalDispatcher();
        String jcamServiceUrl = dispUrl + "/jcamservice";
        try (RESTClient restClient = this.rcFactory.getClient(new RESTClientConfig());){
            JsonObject jsonRequest = new JsonObject();
            jsonRequest.put("keyid", (Object)encodedKeyAlias);
            int status = restClient.createResource(jcamServiceUrl, "application/json", jsonRequest);
            if (status != 202) {
                LOGGER.error("Cannot contact local dispatcher " + jcamServiceUrl);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception when calling key sync service " + e.toString());
        }
    }

    public byte[] getCurrentCSKAlias() throws CAMCryptoException {
        SecretKey currentCSK;
        if (this.needToUpdateCurrentCSKAlias && (currentCSK = this.getCSK()) != null) {
            this.currentCSKAlias = this.getCSKAlias(currentCSK);
            this.needToUpdateCurrentCSKAlias = false;
        }
        return this.currentCSKAlias;
    }

    public byte[] getCSKAlias(SecretKey theKey) {
        MessageDigest md = null;
        try {
            md = JcaFactory.getInstance(MessageDigest.class, CAMConfiguration.getInstance().getCSKDigestAlgorithm());
            md.reset();
            md.update(theKey.getEncoded());
            byte[] cskDigest = md.digest();
            return cskDigest;
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new RuntimeException("CSK digest algorithm does not exist: " + CAMConfiguration.getInstance().getCSKDigestAlgorithm(), e);
        }
    }

    public int getCSKAliasLength() throws CAMCryptoException {
        MessageDigest md = null;
        try {
            md = JcaFactory.getInstance(MessageDigest.class, CAMConfiguration.getInstance().getCSKDigestAlgorithm());
            return md.getDigestLength();
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new RuntimeException("CSK digest algorithm does not exist: " + CAMConfiguration.getInstance().getCSKDigestAlgorithm(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getCSKNotSynchronized(String keyAlias) throws CAMCryptoException {
        String decPassword = this.decryptPasswordIfReq();
        SecretKey theKey = null;
        try {
            KeyStore.SecretKeyEntry theKeyEntry = null;
            try {
                this.readLock.lock();
                theKeyEntry = (KeyStore.SecretKeyEntry)this.bks.getEntry(keyAlias, new KeyStore.PasswordProtection(decPassword.toCharArray()));
            }
            finally {
                this.readLock.unlock();
            }
            if (theKeyEntry == null) {
                this.load();
                try {
                    this.readLock.lock();
                    theKeyEntry = (KeyStore.SecretKeyEntry)this.bks.getEntry(keyAlias, new KeyStore.PasswordProtection(decPassword.toCharArray()));
                }
                finally {
                    this.readLock.unlock();
                }
            }
            if (theKeyEntry != null) {
                theKey = theKeyEntry.getSecretKey();
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_key_with_alias, (Object)keyAlias, (Object)this.ksFilename));
        }
        return theKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws CAMCryptoException {
        LOGGER.trace("Start loading CSK store");
        String decPassword = this.decryptPasswordIfReq();
        this.lock();
        try {
            File file = new File(this.bksFilename);
            if (file.exists()) {
                LOGGER.trace("Start loading existing CSK file: " + this.bksFilename);
                try (FileInputStream stream = new FileInputStream(this.bksFilename);){
                    Enumeration<String> aliases = null;
                    ArrayList<String> cskEntries = new ArrayList<String>();
                    try {
                        this.writeLock.lock();
                        this.bks.load(stream, decPassword.toCharArray());
                        aliases = this.bks.aliases();
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        cskEntries.add(alias);
                    }
                    LOGGER.trace("Completed loading CSK file: " + this.bksFilename + ", CSK aliases are: " + cskEntries.toString());
                }
            }
            LOGGER.trace("Start initializing CSK store");
            try {
                this.writeLock.lock();
                this.bks.load(null, null);
            }
            finally {
                this.writeLock.unlock();
            }
            LOGGER.trace("Completed initializing CSK store");
            this.needToUpdateCurrentCSKAlias = true;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_keystore, (Object)this.bksFilename));
        }
        finally {
            this.unlock();
        }
        LOGGER.trace("Completed loading CSK store");
    }

    private void lock() throws CAMCryptoException {
        try {
            this.ksLock = new CAMLockFile(this.ksLockFilename);
            this.ksLock.lock();
        }
        catch (IOException e) {
            if (this.ksLock != null) {
                this.unlock();
            }
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_acquire_keystore_lock, (Object)this.ksLockFilename));
        }
    }

    private void save() throws CAMCryptoException {
        String decPassword = this.decryptPasswordIfReq();
        this.lock();
        try {
            this.readLock.lock();
            this.bks.store(new FileOutputStream(this.bksFilename), decPassword.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_store_keystore, (Object)this.bksFilename));
        }
        finally {
            this.readLock.unlock();
            this.unlock();
        }
    }

    public void storeCSK(SecretKey theKey, boolean isCurrentCSK) throws CAMCryptoException {
        String decPassword = this.decryptPasswordIfReq();
        String cskAlias = null;
        if (isCurrentCSK) {
            cskAlias = CURRENT_CSK_ALIAS;
        } else {
            try {
                cskAlias = new String(Base64.encodeBase64((byte[])this.getCSKAlias(theKey)), "UTF-8").toLowerCase();
            }
            catch (UnsupportedEncodingException e) {
                throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_store_key_with_alias, (Object)"<null>", (Object)this.bksFilename));
            }
        }
        try {
            this.writeLock.lock();
            this.bks.setEntry(cskAlias, new KeyStore.SecretKeyEntry(theKey), new KeyStore.PasswordProtection(decPassword.toCharArray()));
        }
        catch (KeyStoreException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_store_key_with_alias, (Object)cskAlias, (Object)this.bksFilename));
        }
        finally {
            this.writeLock.unlock();
        }
        this.save();
    }

    private void unlock() throws CAMCryptoException {
        try {
            this.ksLock.unlock();
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_unlock_keystore_lock, (Object)this.ksLockFilename));
        }
        this.ksLock = null;
    }

    static {
        testLock = new Object();
    }
}

