/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.keystore;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.api.CAMKeyPair;
import com.ibm.bi.platform.commons.crypto.api.Parameters;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDistributor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyDistributor.class);
    private static Map<String, String> providerNameToClassName = new HashMap<String, String>();
    private static String defaultProviderName;
    KeyDistributorSpi keyDisributorSpi;

    private KeyDistributor(KeyDistributorSpi keyDistributorSpi) {
        this.keyDisributorSpi = keyDistributorSpi;
        assert (this.keyDisributorSpi != null);
    }

    public static void addProvider(String name, String className) throws CAMCryptoException {
        KeyDistributorSpi keyDistributorSpi = null;
        try {
            keyDistributorSpi = (KeyDistributorSpi)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_add_provider.buildMessage((Object)className));
        }
        if (keyDistributorSpi != null) {
            providerNameToClassName.put(name.toLowerCase(), className);
        }
    }

    public static KeyDistributor getInstance() throws CAMCryptoException {
        return KeyDistributor.getInstance(defaultProviderName);
    }

    public static KeyDistributor getInstance(String providerName) throws CAMCryptoException {
        try {
            String providerClassName = providerNameToClassName.get(providerName.toLowerCase());
            KeyDistributorSpi keyDistributorSpi = (KeyDistributorSpi)Class.forName(providerClassName).newInstance();
            return new KeyDistributor(keyDistributorSpi);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_instantiate_key_distributor.buildMessage((Object)providerName));
        }
    }

    public CAMKeyPair getKeyPair(String algorithm) throws CAMCryptoException {
        return this.keyDisributorSpi.engineGetKeyPair(algorithm);
    }

    public CAMKeyPair getKeyPair(String algorithm, Parameters params) throws CAMCryptoException {
        return this.keyDisributorSpi.engineGetKeyPair(algorithm, params);
    }

    static {
        try {
            KeyDistributor.addProvider("local", "com.ibm.bi.platform.commons.crypto.internal.keystore.LocalKeyDistributorProvider");
            defaultProviderName = "local";
            LOGGER.info("default key distributor provider is set to {}", (Object)defaultProviderName);
        }
        catch (CAMCryptoException e) {
            LOGGER.error("couldn't add the default key distributor provider", (Throwable)((Object)e));
        }
    }

    public static abstract class KeyDistributorSpi {
        public abstract CAMKeyPair engineGetKeyPair(String var1) throws CAMCryptoException;

        public abstract CAMKeyPair engineGetKeyPair(String var1, Parameters var2) throws CAMCryptoException;
    }
}

