/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.session;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.utils.CryptoParams;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.crypto.internal.utils.KeysAndCertsGenerator;
import com.ibm.bi.platform.commons.messages.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaKeyStoreSession {
    public static final String KeyStore_Type = "JKS";
    public static final String Default_Alias = "default";
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaKeyStoreSession.class);

    public void createKeystoreWithKeyAndSelfSignedCert(String keystoreFileName, String password) throws CAMCryptoException {
        LOGGER.trace("Start creating keystore: " + keystoreFileName);
        try {
            this.validateInputParameters(keystoreFileName, password);
        }
        catch (CAMCryptoException e) {
            LOGGER.error("Invalid input parameter with method : createKeystoreWithKeyAndSelfSignedCert");
            throw new CAMCryptoException((Throwable)((Object)e), new Message(CamCryptoMessageKeys.invalid_input_parameter, (Object)"createKeystoreWithKeyAndSelfSignedCert"));
        }
        File file = new File(keystoreFileName);
        keystoreFileName = file.getAbsolutePath();
        String timeNow = this.timeNowAsString();
        X500Principal principal = new X500Principal("CN=CAM_" + timeNow + ", OU=Cognos, O=IBM, C=CA");
        String keyAlgorithm = "RSA";
        int certExpireInDays = 365;
        try {
            KeyPair keyPair = KeysAndCertsGenerator.newKeyPair("RSA", CryptoParams.getInstance().keyLength("RSA"));
            if (keyPair == null) {
                LOGGER.error("Could not generate key pair");
                throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_generate_keypair));
            }
            Date today = new Date();
            X509Certificate selfSignedCert = KeysAndCertsGenerator.selfSignedCertificate(principal, keyPair.getPrivate(), keyPair.getPublic(), CryptoParams.getInstance().signatureAlgorithm("RSA"), today, certExpireInDays);
            if (selfSignedCert == null) {
                LOGGER.error("Could not generate self-signed certificate");
                throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_generate_selfsigned_cert));
            }
            Certificate[] chain = new X509Certificate[]{selfSignedCert};
            KeyStore keyStore = this.createJavaKeyStoreObject();
            keyStore.setKeyEntry(Default_Alias, keyPair.getPrivate(), password.toCharArray(), chain);
            this.storeKeyStoreToFile(keyStore, keystoreFileName, password);
        }
        catch (CAMCryptoException | KeyStoreException e) {
            LOGGER.error("Could not create KeyStore : " + keystoreFileName + " with exception: " + ((Throwable)e).getMessage());
            throw new CAMCryptoException((Throwable)e, new Message(CamCryptoMessageKeys.could_not_store_keystore, (Object)keystoreFileName));
        }
        LOGGER.trace("Successfully created key store: " + keystoreFileName);
    }

    public void deleteKeyStore(String keystoreFileName) throws CAMCryptoException {
        File keystoreFile = new File(keystoreFileName);
        try {
            Files.deleteIfExists(keystoreFile.toPath());
        }
        catch (IOException e1) {
            LOGGER.error("Could not delete keystore file: " + keystoreFileName);
            throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_delete_file, (Object)keystoreFileName));
        }
    }

    private void validateInputParameters(String keystoreFileName, String password) throws CAMCryptoException {
        if (keystoreFileName == null || keystoreFileName.length() == 0) {
            LOGGER.error("Invalid input parameter : Null or empty file name");
            throw new CAMCryptoException(new Message(CamCryptoMessageKeys.empty_file_name));
        }
        if (password == null || password.length() == 0) {
            LOGGER.error("Invalid input parameter : Null or empty password");
            throw new CAMCryptoException(new Message(CamCryptoMessageKeys.empty_password));
        }
    }

    private KeyStore createJavaKeyStoreObject() throws CAMCryptoException {
        KeyStore keyStore = null;
        try {
            keyStore = JcaFactory.getInstance(KeyStore.class, KeyStore_Type);
            keyStore.load(null, null);
        }
        catch (JcaFactory.CouldNotGetInstanceException | IOException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.error("Not able to create Java KeyStore objecet");
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_get_keystore_instance, (Object)KeyStore_Type));
        }
        return keyStore;
    }

    private void storeKeyStoreToFile(KeyStore keyStore, String keystoreFileName, String password) throws CAMCryptoException {
        this.deleteKeyStore(keystoreFileName);
        try {
            keyStore.store(new FileOutputStream(keystoreFileName), password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.error("Not able to delete KeyStore file; " + keystoreFileName);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_store_keystore, (Object)keystoreFileName));
        }
    }

    private String timeNowAsString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("YYYYMMddhhmmss");
        return simpleDateFormat.format(new Date());
    }
}

