/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.session;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.messages.Message;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public abstract class SPSCipher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encryptData(byte[] plainText) throws CAMCryptoException {
        SecretKeySpec key;
        block9: {
            byte[] rawKey = null;
            try {
                rawKey = this.getSystemKey();
                key = this.createSecretKeySpec(rawKey);
                if (rawKey == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.syskey_gen_error));
                }
                catch (Throwable throwable) {
                    if (rawKey != null) {
                        for (int i = 0; i < rawKey.length; ++i) {
                            rawKey[i] = 0;
                        }
                    }
                    throw throwable;
                }
            }
            for (int i = 0; i < rawKey.length; ++i) {
                rawKey[i] = 0;
            }
        }
        try {
            Cipher cipher = this.getCipher();
            cipher.init(1, key);
            byte[] cipherText = cipher.doFinal(plainText);
            return this.addExtraData(cipherText);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.sys_prot_key_encrypt_failure));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decryptData(byte[] encryptedData) throws CAMCryptoException {
        SecretKeySpec key;
        byte[] ciphertext;
        block9: {
            byte[] rawKey = null;
            try {
                ciphertext = this.removeExtraData(encryptedData);
                rawKey = this.getSystemKey();
                key = this.createSecretKeySpec(rawKey);
                if (rawKey == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.syskey_gen_error));
                }
                catch (Throwable throwable) {
                    if (rawKey != null) {
                        for (int i = 0; i < rawKey.length; ++i) {
                            rawKey[i] = 0;
                        }
                    }
                    throw throwable;
                }
            }
            for (int i = 0; i < rawKey.length; ++i) {
                rawKey[i] = 0;
            }
        }
        try {
            Cipher cipher = this.getCipher();
            cipher.init(2, key);
            return cipher.doFinal(ciphertext);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.sys_prot_key_decrypt_failure));
        }
    }

    protected abstract SecretKeySpec createSecretKeySpec(byte[] var1);

    protected abstract byte[] getSystemKey() throws Exception;

    protected abstract Cipher getCipher() throws Exception;

    protected abstract byte[] addExtraData(byte[] var1) throws CAMCryptoException;

    protected abstract byte[] removeExtraData(byte[] var1) throws Exception;

    public abstract int getType();
}

