/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.session;

import com.ibm.bi.platform.commons.crypto.internal.key.CAMByteBuffer;
import com.ibm.bi.platform.commons.crypto.internal.session.SPSCipher;
import com.ibm.bi.platform.commons.crypto.internal.utils.IJVMEnvironment;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SPSCipherDESwParity
extends SPSCipher {
    public static final int TYPE = 2;
    private final IJVMEnvironment jvmEnv;

    public SPSCipherDESwParity(IJVMEnvironment theJvmEnv) {
        this.jvmEnv = theJvmEnv;
    }

    @Override
    protected SecretKeySpec createSecretKeySpec(byte[] rawKey) {
        byte[] rawKeyWithParity = SPSCipherDESwParity.addParity(rawKey);
        return new SecretKeySpec(rawKeyWithParity, 0, 8, "DES");
    }

    private static byte[] addParity(byte[] in) {
        byte[] result = new byte[8];
        int resultIx = 1;
        int bitCount = 0;
        for (int i = 0; i < 56; ++i) {
            boolean bit;
            boolean bl = bit = (in[6 - i / 8] & 1 << i % 8) > 0;
            if (bit) {
                int n = 7 - resultIx / 8;
                result[n] = (byte)(result[n] | 1 << resultIx % 8 & 0xFF);
                ++bitCount;
            }
            if ((i + 1) % 7 == 0) {
                if (bitCount % 2 == 0) {
                    int n = 7 - resultIx / 8;
                    result[n] = (byte)(result[n] | 1);
                }
                ++resultIx;
                bitCount = 0;
            }
            ++resultIx;
        }
        return result;
    }

    @Override
    protected Cipher getCipher() throws Exception {
        return Cipher.getInstance("DES/ECB/PKCS5Padding", this.jvmEnv.getPBEProvider());
    }

    @Override
    protected byte[] getSystemKey() {
        return new CAMByteBuffer().getByteBuffer2(0);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    protected byte[] addExtraData(byte[] cipherText) {
        return cipherText;
    }

    @Override
    protected byte[] removeExtraData(byte[] data) {
        return data;
    }
}

