/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.SimpleTimeZone;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTCTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodedCSK {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncodedCSK.class);
    private static HashMap<String, String> _oid2algMap = new HashMap();
    private static HashMap<String, String> _alg2oidMap;
    private SecretKey _key;
    private Date _date;
    private boolean wasInOldFormat;

    EncodedCSK(Date creationTime, SecretKey key) {
        LOGGER.trace("EncodedCSK creationTime = " + creationTime.toString());
        this.wasInOldFormat = false;
        this._date = creationTime;
        this._key = key;
        LOGGER.trace("EncodedCSK exiting");
    }

    EncodedCSK(byte[] blob) throws IOException {
        LOGGER.trace("EncodedCSK blob length = " + blob.length);
        byte version = blob[0];
        byte dateSize = blob[1];
        int cskLength = blob.length - dateSize - 2;
        if (blob.length == 8) {
            this.wasInOldFormat = true;
            this._key = new SecretKeySpec(blob, "DES");
            this._date = new Date();
        } else if (version == 0 && cskLength == 8) {
            this.wasInOldFormat = true;
            LOGGER.trace("Version 0 of the old format");
            byte[] rawDate = new byte[dateSize];
            byte[] rawCsk = new byte[blob.length - dateSize - 2];
            System.arraycopy(blob, 2, rawDate, 0, rawDate.length);
            System.arraycopy(blob, dateSize + 2, rawCsk, 0, rawCsk.length);
            this._key = new SecretKeySpec(rawCsk, "DES");
            String dateAsString = new String(rawDate);
            try {
                this._date = DateFormat.getDateTimeInstance(3, 3, Locale.US).parse(dateAsString);
            }
            catch (ParseException e) {
                this._date = new Date();
            }
        } else if (version == 1) {
            this.wasInOldFormat = false;
            LOGGER.trace("New format");
            ASN1InputStream dis = new ASN1InputStream((InputStream)new ByteArrayInputStream(blob, 1, blob.length - 1));
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)dis.readObject());
            ASN1ObjectIdentifier algOID = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0));
            ASN1Primitive derObj = seq.getObjectAt(1).toASN1Primitive();
            DERUTCTime creationDate = (DERUTCTime)derObj;
            ASN1OctetString keyBlob = ASN1OctetString.getInstance((Object)seq.getObjectAt(2));
            String algName = _oid2algMap.get(algOID.getId());
            this._key = new SecretKeySpec(keyBlob.getOctets(), algName);
            try {
                SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyyMMddHHmmsszzz");
                simpledateformat.setTimeZone(new SimpleTimeZone(0, "GMT"));
                this._date = simpledateformat.parse(creationDate.getAdjustedTime().substring(0, 17));
            }
            catch (ParseException e) {
                this._date = new Date();
            }
        } else {
            IOException ioe = new IOException("wrong version number");
            LOGGER.trace("EncodeCSK throwing IOException");
            throw ioe;
        }
        LOGGER.trace("EncodeCSK exiting");
    }

    boolean getWasInOldFormat() {
        return this.wasInOldFormat;
    }

    Date getCreationDate() {
        return this._date;
    }

    SecretKey getKey() {
        return this._key;
    }

    void setCreationDate(Date date) {
        this._date = date;
    }

    void setKey(SecretKey key) {
        this._key = key;
    }

    byte[] getEncoded() throws IOException {
        LOGGER.trace("getEncoded");
        String alg = this._key.getAlgorithm();
        String oid = null;
        if (alg.compareTo("AES") == 0) {
            if (this._key.getEncoded().length * 8 == 128) {
                oid = _alg2oidMap.get("AES-128");
            } else if (this._key.getEncoded().length * 8 == 256) {
                oid = _alg2oidMap.get("AES-256");
            }
        } else {
            oid = _alg2oidMap.get(this._key.getAlgorithm());
        }
        ASN1ObjectIdentifier algOID = new ASN1ObjectIdentifier(oid);
        DERUTCTime creationDate = new DERUTCTime(this._date);
        DEROctetString keyBlob = new DEROctetString(this._key.getEncoded());
        DEREncodableVector derVector = new DEREncodableVector();
        derVector.add((ASN1Encodable)algOID);
        derVector.add((ASN1Encodable)creationDate);
        derVector.add((ASN1Encodable)keyBlob);
        DERSequence seq = new DERSequence((ASN1EncodableVector)derVector);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        baos.flush();
        DEROutputStream dos = new DEROutputStream((OutputStream)baos);
        dos.writeObject((ASN1Encodable)seq);
        if (baos == null || baos.size() == 0) {
            LOGGER.trace("Byte array null or empty");
        } else {
            LOGGER.trace("Returning byte array");
        }
        return baos.toByteArray();
    }

    public static String lookupAlg(SecretKey s) {
        String oid = _alg2oidMap.get(s.getAlgorithm());
        String alg = _oid2algMap.get(oid);
        if (alg == null || alg.length() == 0) {
            LOGGER.trace("Algorithm is null or empty");
        } else {
            LOGGER.trace("Returning algorithm " + alg);
        }
        return alg;
    }

    static {
        _oid2algMap.put("1.2.840.113549.3.7", "DESede");
        _oid2algMap.put("1.2.840.113549.3.2", "RC2");
        _oid2algMap.put("1.2.840.113549.3.4", "RC4");
        _oid2algMap.put("1.3.14.3.2.7", "DES");
        _oid2algMap.put("2.16.840.1.101.3.4.1.2", "AES");
        _oid2algMap.put("2.16.840.1.101.3.4.1.42", "AES");
        _alg2oidMap = new HashMap();
        _alg2oidMap.put("3DES", "1.2.840.113549.3.7");
        _alg2oidMap.put("DESede", "1.2.840.113549.3.7");
        _alg2oidMap.put("RC2", "1.2.840.113549.3.2");
        _alg2oidMap.put("RC4", "1.2.840.113549.3.4");
        _alg2oidMap.put("ARCFOUR", "1.2.840.113549.3.4");
        _alg2oidMap.put("DES", "1.3.14.3.2.7");
        _alg2oidMap.put("AES", "2.16.840.1.101.3.4.1.2");
        _alg2oidMap.put("AES-128", "2.16.840.1.101.3.4.1.2");
        _alg2oidMap.put("AES-256", "2.16.840.1.101.3.4.1.42");
    }
}

