/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.internal.utils.Tuples;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GenericUtils {
    public static <T> Optional<T> firstSuccessfulResult(Supplier<T> ... suppliers) {
        return Arrays.stream(suppliers).map(supplier -> {
            try {
                return supplier.get();
            }
            catch (RuntimeException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst();
    }

    public static <T> Supplier<T> throwingSupplierToSupplier(ThrowingSupplier<T, Exception> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static <K, V> Map<K, V> mapFromKeyValTuples(Tuples.Tuple2<K, V> ... kvTuples) {
        return Arrays.stream(kvTuples).collect(Collectors.toMap(t -> t._1, t -> t._2));
    }

    public static <T> Optional<T> supplierToOptional(Supplier<T> errorProneSupplier) {
        try {
            return Optional.ofNullable(errorProneSupplier.get());
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public static <T> List<T> buildListSafely(T ... elts) {
        return Arrays.stream(elts).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Optional<String> systemProperty(String key) {
        return Optional.ofNullable(System.getProperty(key));
    }

    public static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

