/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.internal.utils.CryptoParams;
import com.ibm.bi.platform.commons.crypto.internal.utils.GenericUtils;
import com.ibm.bi.platform.commons.crypto.internal.utils.Tuples;
import java.util.Map;

public class NISTCryptoParams
extends CryptoParams {
    private static Map<String, String> cryptoAlgorithmToSignatureAlgorithm = GenericUtils.mapFromKeyValTuples(new Tuples.Tuple2<String, String>("RSA", "SHA256withRSA"), new Tuples.Tuple2<String, String>("EC", "SHA256withECDSA"));
    private static Map<String, Integer> cryptoAlgorithmToMinKeyLength = GenericUtils.mapFromKeyValTuples(new Tuples.Tuple2<String, Integer>("RSA", 2048), new Tuples.Tuple2<String, Integer>("EC", 224));
    private static Map<String, Integer> cryptoAlgorithmToKeyLength = GenericUtils.mapFromKeyValTuples(new Tuples.Tuple2<String, Integer>("RSA", 2048), new Tuples.Tuple2<String, Integer>("EC", 256));

    @Override
    public String signatureAlgorithm(String cryptoAlgorithm) {
        return cryptoAlgorithmToSignatureAlgorithm.get(cryptoAlgorithm.toUpperCase());
    }

    @Override
    public int minKeyLength(String cryptoAlgorithm) {
        return cryptoAlgorithmToMinKeyLength.get(cryptoAlgorithm.toUpperCase());
    }

    @Override
    public int keyLength(String cryptoAlgorithm) {
        return cryptoAlgorithmToKeyLength.get(cryptoAlgorithm.toUpperCase());
    }
}

