/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.http;

import com.ibm.bi.platform.commons.http.util.HttpUtils;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHttpClientConfig {
    private static final Logger LOGGER;
    protected String scheme = "http";
    protected String server = "localhost";
    protected String pathRoot = "";
    protected int port = 80;
    protected URI baseURI;
    protected Map<String, Header> requestHeaders = new HashMap<String, Header>();
    private List<HttpCookie> cookies;
    private static String envScheme;
    private static String envHost;
    private static int envPort;
    protected static final HeaderGroup ignoreRequestHeaders;

    public BaseHttpClientConfig() {
        try {
            String defaultAddress = this.getDefaultAddress();
            if (StringUtils.isNotEmpty((String)defaultAddress) && !StringUtils.equalsIgnoreCase((String)"default", (String)defaultAddress)) {
                this.initFromURL(new URL(defaultAddress));
            }
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Bad default address URL", (Throwable)e);
        }
    }

    protected String getDefaultAddress() {
        return HttpUtils.getDefaultAddress();
    }

    public BaseHttpClientConfig(HttpServletRequest request) {
        this();
        this.initCookies(request);
        String defaultAddress = this.getDefaultAddress();
        URL caEndpoint = HttpUtils.getCAEndpoint(request);
        if (caEndpoint != null) {
            this.initFromURL(caEndpoint);
            this.pathRoot = caEndpoint.getPath();
        } else if (StringUtils.isNotEmpty((String)envScheme) && StringUtils.isNotEmpty((String)envHost) && envPort != -1) {
            this.scheme = envScheme;
            this.server = envHost;
            this.port = envPort;
        } else if (StringUtils.isEmpty((String)defaultAddress) || StringUtils.equalsIgnoreCase((String)"default", (String)defaultAddress)) {
            this.scheme = request.getScheme();
            this.server = request.getLocalName();
            this.port = request.getLocalPort();
        }
        ServletContext context = request.getServletContext();
        if (context != null) {
            this.setRequestHeader("x-ca-service", context.getContextPath().substring(1));
        }
    }

    protected void initCookies(HttpServletRequest request) {
        Cookie[] cookies;
        if (request != null && (cookies = request.getCookies()) != null) {
            ArrayList<HttpCookie> httpCookies = new ArrayList<HttpCookie>();
            for (Cookie cookie : cookies) {
                HttpCookie httpCookie = new HttpCookie(cookie.getName(), cookie.getValue());
                httpCookie.setVersion(cookie.getVersion());
                httpCookies.add(httpCookie);
            }
            this.setCookies(httpCookies);
        }
    }

    private void initFromURL(URL url) {
        this.scheme = url.getProtocol();
        this.server = url.getHost();
        this.port = url.getPort();
    }

    public URI getBaseURI() throws URISyntaxException {
        if (this.baseURI == null) {
            URI hostURI = new URI(this.scheme, null, this.getServer(), this.getPort(), "/", null, null);
            String path = this.getPathRoot();
            if (path != null && !path.isEmpty()) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                this.baseURI = hostURI.resolve(path);
            } else {
                this.baseURI = hostURI;
            }
        }
        return this.baseURI;
    }

    public void setRequestHeader(String name, String value) {
        if (value == null) {
            this.requestHeaders.remove(name.toLowerCase());
        } else {
            this.requestHeaders.put(name.toLowerCase(), (Header)new BasicHeader(name, value));
        }
    }

    public void clearRequestHeaders() {
        this.requestHeaders.clear();
    }

    public Collection<Header> getRequestHeaders() {
        return this.requestHeaders.values();
    }

    public Header getRequestHeader(String name) {
        return this.requestHeaders.get(name.toLowerCase());
    }

    protected void setXSRFTokenHeader() {
        String fakeXSRFToken = HttpUtils.generateNewXSRFToken();
        if (!this.requestHeaders.containsKey("X-XSRF-TOKEN".toLowerCase())) {
            for (HttpCookie cookie : this.getCookies()) {
                if (!cookie.getName().equalsIgnoreCase("XSRF-TOKEN")) continue;
                this.setRequestHeader("X-XSRF-TOKEN", cookie.getValue());
                return;
            }
            this.setRequestHeader("X-XSRF-TOKEN", fakeXSRFToken);
            this.setCookie(new HttpCookie("XSRF-TOKEN", fakeXSRFToken));
        }
    }

    public List<HttpCookie> getCookies() {
        return this.cloneCookies(this.cookies);
    }

    private List<HttpCookie> cloneCookies(List<HttpCookie> cookies) {
        ArrayList<HttpCookie> clonedCookies = new ArrayList<HttpCookie>();
        if (cookies != null) {
            Supplier<List> supplier = () -> clonedCookies;
            cookies.stream().collect(Collectors.toCollection(supplier));
        }
        return clonedCookies;
    }

    public void setCookies(List<HttpCookie> cookies) {
        StringBuilder cookieHeaderValue = new StringBuilder();
        if (cookies != null && cookies.size() > 0) {
            HttpCookie cookie = null;
            Iterator<HttpCookie> it = cookies.iterator();
            while (it.hasNext()) {
                cookie = it.next();
                if (cookie.getValue() == null || cookie.getValue().length() <= 0) continue;
                cookieHeaderValue.append(cookie.getName()).append("=").append(cookie.getValue());
                if (!it.hasNext()) continue;
                cookieHeaderValue.append("; ");
            }
        }
        this.setRequestHeader("cookie", cookieHeaderValue.toString());
        this.cookies = this.cloneCookies(cookies);
    }

    protected void prePopulateRequestHeaders(HttpServletRequest request) {
        Enumeration incomingHeaders = request.getHeaderNames();
        while (incomingHeaders.hasMoreElements()) {
            String headerName = (String)incomingHeaders.nextElement();
            if (ignoreRequestHeaders.containsHeader(headerName) || HttpUtils.hopByHopHeaders.containsHeader(headerName) || headerName.startsWith("X-Forwarded")) continue;
            StringBuilder value = new StringBuilder();
            Enumeration values = request.getHeaders(headerName);
            while (values.hasMoreElements()) {
                value.append(value.length() > 0 ? "," : "").append((String)values.nextElement());
            }
            this.requestHeaders.put(headerName.toLowerCase(), (Header)new BasicHeader(headerName, value.toString()));
        }
    }

    protected void setTransactionCookie() {
        List<HttpCookie> cookies = this.getCookies();
        Header transactionHeader = this.getRequestHeader("X-CA-Transaction");
        if (transactionHeader != null) {
            HttpCookie transCookie = null;
            try {
                String newValue = URLEncoder.encode(transactionHeader.getValue(), "UTF-8");
                for (HttpCookie cookie : cookies) {
                    if (!cookie.getName().equalsIgnoreCase("CATransaction")) continue;
                    transCookie = cookie;
                    transCookie.setValue(newValue);
                    break;
                }
                if (transCookie == null) {
                    transCookie = new HttpCookie("CATransaction", newValue);
                    cookies.add(transCookie);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.setCookies(cookies);
        }
    }

    public String getPathRoot() {
        return this.pathRoot;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public void setCookie(HttpCookie cookie) {
        ArrayList<HttpCookie> newList = new ArrayList<HttpCookie>();
        List<HttpCookie> currentList = this.getCookies();
        if (currentList != null) {
            Supplier<List> supplier = () -> newList;
            currentList.stream().map(c -> cookie.getName().equals(c.getName()) ? cookie : c).collect(Collectors.toCollection(supplier));
        }
        if (!newList.contains(cookie)) {
            newList.add(cookie);
        }
        this.setCookies(newList);
    }

    static {
        String[] headers;
        LOGGER = LoggerFactory.getLogger(BaseHttpClientConfig.class);
        envScheme = null;
        envHost = null;
        envPort = -1;
        envScheme = System.getenv("SERVER_SCHEME");
        envHost = System.getenv("SERVER_HOST");
        String portString = System.getenv("PORT");
        if (StringUtils.isNotBlank((String)portString)) {
            try {
                envPort = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid value in 'port' environment variable: {}", (Object)portString);
            }
        }
        ignoreRequestHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Content-Length", "Content-Type", "Accept-Encoding", "Host", "Referer", "Pragma", "X-Requested-With", "Cache-Control", "User-Agent", "X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Proto", "Forwarded", "X-CA-XSSEncoded", "X-CA-Authorization", "X-Http-Method-Override", "x-ca-variant", "If-Match", "If-None-Match", "If-Modified-Since", "If-Unmodified-Since", "If-Range"}) {
            ignoreRequestHeaders.addHeader((Header)new BasicHeader(header, null));
        }
    }
}

