/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.google.common.collect.Maps;
import com.netflix.config.DynamicStringListProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicMapProperty<TKEY, TVAL>
extends DynamicStringListProperty {
    private static final Logger logger = LoggerFactory.getLogger(DynamicMapProperty.class);
    private Map<TKEY, TVAL> defaultValuesMap = this.parseMapFromStringList((List<String>)this.getDefaultValue());
    private volatile Map<TKEY, TVAL> values;

    public DynamicMapProperty(String propName, String defaultValue, String mapEntryDelimiterRegex) {
        super(propName, defaultValue, mapEntryDelimiterRegex);
    }

    public DynamicMapProperty(String propName, String defaultValue) {
        super(propName, defaultValue);
    }

    public DynamicMapProperty(String propName, Map<TKEY, TVAL> defaultValue, String mapEntryDelimiterRegex) {
        this(propName, (String)null, mapEntryDelimiterRegex);
        Map<Object, Object> map = this.defaultValuesMap = defaultValue == null ? null : Collections.unmodifiableMap(Maps.newHashMap(defaultValue));
        if (this.defaultValuesMap != null && this.values.isEmpty()) {
            this.values = this.defaultValuesMap;
        }
    }

    public DynamicMapProperty(String propName, Map<TKEY, TVAL> defaultValue) {
        this(propName, defaultValue, ",");
    }

    public Map<TKEY, TVAL> getMap() {
        return this.values;
    }

    public Map<TKEY, TVAL> getDefaultValueMap() {
        return this.defaultValuesMap;
    }

    @Override
    protected void load() {
        super.load();
        this.values = this.parseMapFromStringList(super.get());
    }

    protected Map<TKEY, TVAL> parseMapFromStringList(List<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<TKEY, TVAL> map = new HashMap<TKEY, TVAL>(strings.size());
        for (String s : strings) {
            String[] kv = this.getKeyValue(s);
            if (kv.length == 2) {
                map.put(this.getKey(kv[0]), this.getValue(kv[1]));
                continue;
            }
            logger.warn("Ignoring illegal key value pair: " + s);
        }
        return Collections.unmodifiableMap(map);
    }

    protected String[] getKeyValue(String keyValue) {
        return keyValue.split("=");
    }

    protected abstract TKEY getKey(String var1);

    protected abstract TVAL getValue(String var1);
}

