/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.config;

import com.ibm.bi.logging.glug.config.compat.LoggingTopic;
import com.ibm.bi.logging.glug.internal.GsonFactory;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTopicLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(CustomTopicLibrary.class);
    private Path libraryFolder;

    public CustomTopicLibrary(Path libraryFolder) {
        this.libraryFolder = libraryFolder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getTopics() {
        try (Stream<Path> paths = Files.list(this.libraryFolder);){
            List<String> list = paths.map(p -> CustomTopicLibrary.nameFromPath(p)).collect(Collectors.toList());
            return list;
        }
        catch (NoSuchFileException nsfx) {
            LOG.debug("custom topic library folder doesn't exist");
            return Collections.emptyList();
        }
        catch (Exception x) {
            LOG.error("problem listing custom topics", (Throwable)x);
        }
        return Collections.emptyList();
    }

    static String nameFromPath(Path path) {
        return path.getName(path.getNameCount() - 1).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoggingTopic getTopic(String topicName) {
        try (FileReader rdr = new FileReader(this.libraryFolder.resolve(topicName).toFile());){
            LoggingTopic loggingTopic = (LoggingTopic)GsonFactory.makeGson().fromJson((Reader)rdr, LoggingTopic.class);
            return loggingTopic;
        }
        catch (Exception x) {
            LOG.warn("failed to load logging topic {}", (Object)topicName);
            LOG.debug("due to exception", (Throwable)x);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoggingTopic getTopicResource(String resourceName) {
        try (InputStreamReader rdr = new InputStreamReader(this.getClass().getResourceAsStream(resourceName));){
            LoggingTopic loggingTopic = (LoggingTopic)GsonFactory.makeGson().fromJson((Reader)rdr, LoggingTopic.class);
            return loggingTopic;
        }
        catch (Exception x) {
            LOG.warn("failed to load logging topic resource {}", (Object)resourceName);
            LOG.debug("due to exception", (Throwable)x);
            return null;
        }
    }
}

