/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.config;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.ibm.bi.logging.glug.config.CustomTopicLibrary;
import com.ibm.bi.logging.glug.config.LogConfigUpdateEvent;
import com.ibm.bi.logging.glug.config.LoggingSystemConfig;
import com.ibm.bi.logging.glug.config.compat.BuiltinTopicLibrary;
import com.ibm.bi.logging.glug.config.compat.LoggingTopic;
import com.ibm.bi.logging.glug.internal.FileChangeEvent;
import com.ibm.bi.logging.glug.internal.FileChangeMonitor;
import com.ibm.bi.logging.glug.internal.LogEnabler;
import com.ibm.bi.logging.glug.internal.LoggerDefinition;
import com.ibm.bi.logging.glug.internal.LoggingConfiguration;
import com.ibm.bi.logging.glug.internal.Slf4jLogChute;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlugConfigernator {
    private static final Logger LOG = LoggerFactory.getLogger(GlugConfigernator.class);
    private static final String SESSION = "session";
    private static final String STARTUP = "startup";
    private final File configFile;
    private VelocityEngine velocityEngine;
    private ScheduledExecutorService scheduledExecutorService;
    private final File inputFolder;
    private EventBus eventBus;
    private FileChangeMonitor fileChangeMonitor;
    private long checkIntervalSecs;
    private final File log4j2XmlFile;
    private final File ipfclientconfigXmlFile;
    private final BuiltinTopicLibrary builtinTopicLibrary;
    private final CustomTopicLibrary customTopicLibrary;
    private final LoggingSystemConfig loggingSystemConfig;
    private Runnable applyUpdateRunnable = null;

    public GlugConfigernator(LoggingSystemConfig loggingSystemConfig, BuiltinTopicLibrary topicLibrary, CustomTopicLibrary customTopicLibrary, ScheduledExecutorService scheduledExecutorService, EventBus eventBus, File inputFolder, String configFilename, long checkIntervalSecs, File outputFile, File outputFile2) {
        this.builtinTopicLibrary = topicLibrary;
        this.customTopicLibrary = customTopicLibrary;
        this.scheduledExecutorService = scheduledExecutorService;
        this.eventBus = eventBus;
        this.inputFolder = inputFolder;
        this.configFile = new File(inputFolder, configFilename);
        this.checkIntervalSecs = checkIntervalSecs;
        this.log4j2XmlFile = outputFile;
        this.ipfclientconfigXmlFile = outputFile2;
        this.loggingSystemConfig = loggingSystemConfig;
    }

    public void start() throws Exception {
        this.velocityEngine = this.setupVelocityEngine();
        this.updateConfigsAsync();
        this.fileChangeMonitor = new FileChangeMonitor(this.inputFolder, this.scheduledExecutorService, this.checkIntervalSecs, this.eventBus);
        this.eventBus.register((Object)this);
        this.fileChangeMonitor.start();
    }

    public void stop() throws Exception {
        this.checkAndClearPendingUpdate();
        this.fileChangeMonitor.stop();
        this.eventBus.unregister((Object)this);
    }

    private VelocityEngine setupVelocityEngine() {
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.addProperty("runtime.log.logsystem", (Object)new Slf4jLogChute(LOG));
        this.velocityEngine.addProperty("resource.loader", (Object)"class");
        this.velocityEngine.addProperty("class.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
        this.velocityEngine.addProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.velocityEngine.init();
        return this.velocityEngine;
    }

    @Subscribe
    public void onFileChanged(FileChangeEvent event) {
        LOG.info("notified that logging configuration or topic file changed: {}", (Object)event);
        this.updateConfigsAsync();
    }

    @Subscribe
    public void onConfigChanged(LoggingSystemConfig loggingSystemConfig) {
        LOG.info("notified that system level logging configuration changed");
        this.updateConfigsAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigsAsync() {
        GlugConfigernator glugConfigernator = this;
        synchronized (glugConfigernator) {
            if (this.applyUpdateRunnable != null) {
                LOG.debug("updateConfigsAsync: an update is already pending");
                return;
            }
            LOG.debug("queueing update of log config for future execution");
            this.applyUpdateRunnable = this.makeApplyUpdateRunnable();
            long delay = Long.min(this.checkIntervalSecs, 5L);
            this.scheduledExecutorService.schedule(this.applyUpdateRunnable, delay, TimeUnit.SECONDS);
        }
    }

    private synchronized boolean checkAndClearPendingUpdate() {
        boolean updatePending = this.applyUpdateRunnable != null;
        this.applyUpdateRunnable = null;
        return updatePending;
    }

    private Runnable makeApplyUpdateRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (GlugConfigernator.this.checkAndClearPendingUpdate()) {
                        LOG.debug("applyUpdateRunnable: an update was pending so update logging configuration");
                        GlugConfigernator.this.updateLoggers();
                        GlugConfigernator.this.updateipfClientConfig();
                        GlugConfigernator.this.eventBus.post((Object)new LogConfigUpdateEvent());
                    } else {
                        LOG.debug("applyUpdateRunnable: no update was pending");
                    }
                }
                catch (Exception x) {
                    LOG.error("exception occured while updating logging configuration", (Throwable)x);
                    throw x;
                }
            }
        };
    }

    List<LoggerDefinition> buildLoggerList(LoggingConfiguration loggingConfiguration) {
        ArrayList<LoggerDefinition> loggers = new ArrayList<LoggerDefinition>();
        for (LogEnabler logEnabler : loggingConfiguration.getEnabledLoggers()) {
            if (logEnabler == null) continue;
            if (logEnabler.isTopic()) {
                LoggingTopic topic = this.findTopic(logEnabler);
                if (topic == null) {
                    LOG.info("ignoring unknown logging topic name {}", (Object)logEnabler.getTopicName());
                    continue;
                }
                loggers.addAll(topic.getLoggerDefinitions());
                continue;
            }
            loggers.add(logEnabler);
        }
        return loggers;
    }

    List<LoggerDefinition> buildSpecialLoggerList(String prefix, String customTopicName) {
        if (StringUtils.isEmpty((String)customTopicName)) {
            LOG.debug("no custom topic configured for {} logging control, use defaults", (Object)prefix);
            return this.getDefaultLoggerList(prefix);
        }
        LoggingTopic sct = this.customTopicLibrary.getTopic(customTopicName);
        if (sct == null || sct.getLoggerDefinitions().isEmpty()) {
            LOG.warn("configured custom topic: {} for {} logging control not found or empty, using defaults", (Object)customTopicName, (Object)prefix);
            return this.getDefaultLoggerList(prefix);
        }
        return GlugConfigernator.ensureLoggerNamePrefix(prefix, sct.getLoggerDefinitions());
    }

    static List<LoggerDefinition> ensureLoggerNamePrefix(String prefix, List<LoggerDefinition> input) {
        return input.stream().map(ld -> {
            if (ld.getName().startsWith(prefix)) {
                return ld;
            }
            return new LoggerDefinition(prefix + "." + ld.getName(), ld.getLevel());
        }).collect(Collectors.toList());
    }

    List<LoggerDefinition> getDefaultLoggerList(String prefix) {
        return this.customTopicLibrary.getTopicResource("/com/ibm/bi/logging/glug/default_" + prefix + "_logger_topic.js").getLoggerDefinitions();
    }

    LoggingTopic findTopic(LogEnabler logEnabler) {
        switch (logEnabler.getTopicType()) {
            case BUILTIN: {
                return this.builtinTopicLibrary.getTopic(logEnabler.getTopicName());
            }
            case CUSTOM: {
                return this.customTopicLibrary.getTopic(logEnabler.getTopicName());
            }
            case UNSPECIFIED: {
                LoggingTopic topic = this.customTopicLibrary.getTopic(logEnabler.getTopicName());
                if (topic == null) {
                    topic = this.builtinTopicLibrary.getTopic(logEnabler.getTopicName());
                }
                return topic;
            }
        }
        return null;
    }

    private void updateLoggers() {
        Template templ = this.velocityEngine.getTemplate("com/ibm/bi/logging/glug/log4j2_xml.vtl");
        VelocityContext context = new VelocityContext();
        this.addSystemConfig(context);
        LoggingConfiguration loggingConfiguration = LoggingConfiguration.loadOrDefault(this.configFile, this.buildTopicNameTester());
        context.put("loggers", this.buildLoggerList(loggingConfiguration));
        context.put("sessionLoggers", this.buildSpecialLoggerList(SESSION, loggingConfiguration.getSessionCustomTopic()));
        context.put("dispReadySysprop", (Object)"com.ibm.bi.logging.glug.hint.isready");
        context.put("startupLoggers", this.buildSpecialLoggerList(STARTUP, loggingConfiguration.getStartupCustomTopic()));
        context.put("doSocket", (Object)loggingConfiguration.isSocketAppenderEnabled());
        if (loggingConfiguration.isSocketAppenderEnabled().booleanValue()) {
            context.put("socketAppenderHostname", (Object)loggingConfiguration.getSocketAppenderHostname());
            context.put("socketAppenderPort", (Object)loggingConfiguration.getSocketAppenderport());
        }
        context.put("DD", (Object)"$$");
        context.put("D", (Object)"$");
        StringWriter w = new StringWriter();
        LOG.debug("about to process log4j2 template!");
        templ.merge((Context)context, (Writer)w);
        try {
            String newXml = ((Object)w).toString();
            if (this.doUpdate(newXml)) {
                LOG.debug("new generated log4j2 xml is different, so re-write the file.");
                this.replaceLog4j2Config(newXml);
            } else {
                LOG.debug("new generated log4j2 xml is same as the old so do NOT re-write the file.");
            }
        }
        catch (IOException e) {
            LOG.error("failed to update logging configuration file {}", (Object)this.log4j2XmlFile);
            LOG.error("exception occurred: ", (Throwable)e);
        }
    }

    private void updateipfClientConfig() {
        Template templ = this.velocityEngine.getTemplate("com/ibm/bi/logging/glug/ipfclientconfig_xml.vtl");
        VelocityContext context = new VelocityContext();
        this.addSystemConfig(context);
        LoggingConfiguration loggingConfiguration = LoggingConfiguration.loadOrDefault(this.configFile, this.buildTopicNameTester());
        context.put("loggers", this.buildLoggerList(loggingConfiguration));
        context.put("sessionLoggers", this.buildSpecialLoggerList(SESSION, loggingConfiguration.getSessionCustomTopic()));
        context.put("startupLoggers", this.buildSpecialLoggerList(STARTUP, loggingConfiguration.getStartupCustomTopic()));
        context.put("Port_Num", (Object)this.loggingSystemConfig.getLoggingPort());
        if (this.loggingSystemConfig.isLoggingProtocolTCP()) {
            context.put("IPFAppender", (Object)"com.cognos.indications.LogTCPSocketAppender");
            context.put("doTCPparams", (Object)Boolean.TRUE);
            context.put("localhostTCP", (Object)this.loggingSystemConfig.getLoggingHostTCP());
            context.put("secureTCP", (Object)this.loggingSystemConfig.isSecure());
        } else {
            context.put("IPFAppender", (Object)"com.cognos.indications.LogLocalUDPAppender");
            context.put("doTCPparams", (Object)Boolean.FALSE);
        }
        context.put("DD", (Object)"$$");
        context.put("D", (Object)"$");
        StringWriter w = new StringWriter();
        LOG.debug("about to process ipfclientconfig template!");
        templ.merge((Context)context, (Writer)w);
        try {
            String newXml = ((Object)w).toString();
            if (this.doipfClientConfigUpdate(newXml)) {
                LOG.debug("new generated ipfclientconfig xml is different, so re-write the file.");
                this.replaceipfClientConfig(newXml);
            } else {
                LOG.debug("new generated ipfclientconfig xml is same as the old so do NOT re-write the file.");
            }
        }
        catch (IOException e) {
            LOG.error("failed to update ipfclientconfig file {}", (Object)this.ipfclientconfigXmlFile);
            LOG.error("exception occurred: ", (Throwable)e);
        }
    }

    boolean doUpdate(String newXml) throws IOException {
        if (!this.log4j2XmlFile.exists()) {
            LOG.debug("log4j2 config file {} does not yet exist", (Object)this.log4j2XmlFile);
            return true;
        }
        String oldXml = FileUtils.readFileToString((File)this.log4j2XmlFile);
        return !newXml.equals(oldXml);
    }

    boolean doipfClientConfigUpdate(String newXml) throws IOException {
        if (!this.ipfclientconfigXmlFile.exists()) {
            LOG.debug("ipfclientconfig file {} does not yet exist", (Object)this.ipfclientconfigXmlFile);
            return true;
        }
        if (this.loggingSystemConfig.hasLog4cAuditRuntimeChanged()) {
            return true;
        }
        String oldXml = FileUtils.readFileToString((File)this.ipfclientconfigXmlFile);
        return !newXml.equals(oldXml);
    }

    void replaceLog4j2Config(String newXML) throws IOException {
        File tmp = new File(this.log4j2XmlFile.getCanonicalPath() + ".tmp");
        FileUtils.write((File)tmp, (CharSequence)newXML);
        Files.move(tmp.toPath(), this.log4j2XmlFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    void replaceipfClientConfig(String newXML) throws IOException {
        File tmp = new File(this.ipfclientconfigXmlFile.getCanonicalPath() + ".tmp");
        FileUtils.write((File)tmp, (CharSequence)newXML);
        Files.move(tmp.toPath(), this.ipfclientconfigXmlFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    public Predicate<String> buildTopicNameTester() {
        HashSet<String> topicnames = new HashSet<String>();
        topicnames.addAll(this.customTopicLibrary.getTopics());
        topicnames.addAll(this.builtinTopicLibrary.getTopics());
        return t -> topicnames.contains(t);
    }

    private void addSystemConfig(VelocityContext velocityContext) {
        velocityContext.put("LoggingRolloverMBytes", (Object)this.loggingSystemConfig.getLoggingRolloverMBytes());
        velocityContext.put("MaxLoggingFiles", (Object)this.loggingSystemConfig.getMaxLoggingFiles());
        velocityContext.put("SessionLoggingRolloverMBytes", (Object)this.loggingSystemConfig.getSessionLoggingRolloverMBytes());
        velocityContext.put("MaxSessionLoggingFiles", (Object)this.loggingSystemConfig.getMaxSessionLoggingFiles());
        velocityContext.put("SessionLogCleanupEnabled", (Object)this.loggingSystemConfig.isSessionLogCleanupEnabled());
        velocityContext.put("doJson", (Object)this.loggingSystemConfig.isJsonFormatEnabled());
    }
}

