/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.config.compat;

import com.ibm.bi.logging.glug.config.compat.IPFLoggerDef;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFConfigFile
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(IPFConfigFile.class);
    private Reader reader;
    private List<IPFLoggerDef> loggers = new ArrayList<IPFLoggerDef>();

    public IPFConfigFile(Reader reader) {
        this.reader = reader;
    }

    public List<IPFLoggerDef> getLoggers() {
        return Collections.unmodifiableList(this.loggers);
    }

    public void parse() throws Exception {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        XMLEventReader xrdr = factory.createXMLEventReader(this.reader);
        while (xrdr.hasNext()) {
            XMLEvent event = xrdr.nextEvent();
            if (event.isStartElement()) {
                IPFLoggerDef logger;
                StartElement startElem = event.asStartElement();
                if (!this.isElementNamed(startElem, "category") || (logger = this.processCategory(startElem, xrdr)) == null) continue;
                this.loggers.add(logger);
                continue;
            }
            if (!event.isEndDocument()) continue;
            break;
        }
    }

    boolean isElementNamed(StartElement startElem, String name) {
        return name.equals(startElem.getName().getLocalPart());
    }

    private IPFLoggerDef processCategory(StartElement startElem, XMLEventReader xrdr) throws XMLStreamException {
        String name = this.getAttributeWithName(startElem, "name");
        if (name == null) {
            LOG.debug("malformed category element at {}: missing name", (Object)startElem.getLocation());
        } else if (IPFLoggerDef.isIgnoredCategory(name)) {
            LOG.debug("ignoring top-level category element at {}", (Object)startElem.getLocation());
            name = null;
        }
        String level = this.getLevel(xrdr);
        if (level == null) {
            LOG.debug("malformed category element at {}: missing level", (Object)startElem.getLocation());
        }
        if (name != null && level != null) {
            return new IPFLoggerDef(name, level);
        }
        return null;
    }

    String getAttributeWithName(StartElement startElem, String attrName) {
        Iterator<Attribute> it = startElem.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            if (!attrName.equals(attr.getName().getLocalPart())) continue;
            return attr.getValue();
        }
        return null;
    }

    private String getLevel(XMLEventReader xrdr) throws XMLStreamException {
        String level = null;
        while (xrdr.hasNext()) {
            XMLEvent ev = xrdr.nextEvent();
            if (ev.isStartElement()) {
                StartElement startElem = ev.asStartElement();
                if (this.isElementNamed(startElem, "level")) {
                    level = this.getAttributeWithName(startElem, "value");
                    continue;
                }
                this.discardElement(startElem, xrdr);
                continue;
            }
            if (!ev.isEndElement()) continue;
            break;
        }
        return level;
    }

    private void discardElement(StartElement startElem, XMLEventReader xrdr) throws XMLStreamException {
        while (xrdr.hasNext()) {
            XMLEvent ev = xrdr.nextEvent();
            if (ev.isStartElement()) {
                this.discardElement(ev.asStartElement(), xrdr);
                continue;
            }
            if (!ev.isEndElement()) continue;
            break;
        }
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }
}

