/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.config.compat;

import com.ibm.bi.logging.glug.config.compat.IPFLoggerDef;
import com.ibm.bi.logging.glug.internal.GlugMessage;
import com.ibm.bi.logging.glug.internal.LogLevel;
import com.ibm.bi.logging.glug.internal.LoggerDefinition;
import com.ibm.bi.logging.glug.internal.Messages;
import com.ibm.bi.logging.glug.internal.ValidationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LoggingTopic {
    private List<LoggerDefinition> loggerDefinitions;
    private String topicName;

    private LoggingTopic(String topicName) {
        this.topicName = topicName;
        this.loggerDefinitions = new ArrayList<LoggerDefinition>();
    }

    public static LoggingTopic make(String topicName, List<IPFLoggerDef> ipfLoggerDefs) {
        LoggingTopic topic = new LoggingTopic(topicName);
        for (IPFLoggerDef ipfLoggerDef : ipfLoggerDefs) {
            topic.addLogger(new LoggerDefinition(ipfLoggerDef.getName(), LogLevel.forString(ipfLoggerDef.getLevel())));
        }
        return topic;
    }

    public static LoggingTopic makeWithLoggerDefs(String topicName, List<LoggerDefinition> loggerDefs) {
        LoggingTopic topic = new LoggingTopic(topicName);
        topic.loggerDefinitions.addAll(loggerDefs);
        return topic;
    }

    private void addLogger(LoggerDefinition loggerDefinition) {
        this.loggerDefinitions.add(loggerDefinition);
    }

    public List<LoggerDefinition> getLoggerDefinitions() {
        return Collections.unmodifiableList(this.loggerDefinitions);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public ValidationResult validate() {
        if (this.topicName.matches("\\w+")) {
            return LoggerDefinition.validateloggerDefinitions(this.loggerDefinitions);
        }
        ValidationResult result = new ValidationResult(true);
        result.setOk(false);
        result.addMessage(new GlugMessage(Messages.TOPIC_NAME_INVALID, new String[0]));
        return result;
    }
}

