/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.internal;

import com.google.common.eventbus.EventBus;
import com.ibm.bi.logging.glug.internal.FileChangeEvent;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangeMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangeMonitor.class);
    private File watchedFolder;
    private ScheduledExecutorService executorService;
    private EventBus eventBus;
    private ScheduledFuture<?> futureScheduledFileChecks;
    private FileAlterationObserver fileAlterationObserver;
    private long checkInterval;
    private FileAlterationListener fileChangelistener = new FileAlterationListenerAdaptor(){

        public void onFileCreate(File createdFile) {
            LOG.info("notify created file {}/{}", (Object)FileChangeMonitor.this.watchedFolder, (Object)createdFile.getName());
            FileChangeMonitor.this.eventBus.post((Object)new FileChangeEvent(FileChangeEvent.KindOfChange.CREATE, createdFile));
        }

        public void onFileChange(File changedFile) {
            LOG.info("notify change to file {}/{}", (Object)FileChangeMonitor.this.watchedFolder, (Object)changedFile.getName());
            FileChangeMonitor.this.eventBus.post((Object)new FileChangeEvent(FileChangeEvent.KindOfChange.UPDATE, changedFile));
        }

        public void onFileDelete(File deletedFile) {
            LOG.info("notify deleted file {}/{}", (Object)FileChangeMonitor.this.watchedFolder, (Object)deletedFile.getName());
            FileChangeMonitor.this.eventBus.post((Object)new FileChangeEvent(FileChangeEvent.KindOfChange.DELETE, deletedFile));
        }
    };

    public FileChangeMonitor(File watchedFolder, ScheduledExecutorService executorService, long checkIntervalSeconds, EventBus eventBus) {
        this.watchedFolder = watchedFolder;
        this.executorService = executorService;
        this.checkInterval = checkIntervalSeconds;
        this.fileAlterationObserver = new FileAlterationObserver(watchedFolder);
        this.eventBus = eventBus;
    }

    public void start() throws Exception {
        this.fileAlterationObserver.addListener(this.fileChangelistener);
        this.fileAlterationObserver.initialize();
        this.futureScheduledFileChecks = this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                FileChangeMonitor.this.fileAlterationObserver.checkAndNotify();
            }
        }, this.checkInterval, this.checkInterval, TimeUnit.SECONDS);
    }

    public void stop() throws Exception {
        this.futureScheduledFileChecks.cancel(false);
        this.fileAlterationObserver.destroy();
    }
}

