/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.internal;

import com.ibm.bi.logging.glug.internal.GlugMessage;
import com.ibm.bi.logging.glug.internal.LogLevel;
import com.ibm.bi.logging.glug.internal.Messages;
import com.ibm.bi.logging.glug.internal.ValidationResult;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class LoggerDefinition {
    private String loggerName;
    private LogLevel level;
    private Boolean additivity;
    static Set<String> RESERVED_LOGGER_NAMES = new HashSet<String>(){
        {
            this.add("com.ibm");
            this.add("com.ibm.bi");
            this.add("com.ibm.ba");
            this.add("com.ibm.ca");
            this.add("com.ibm.cognos");
            this.add("com.ibm.vida");
            this.add("com.cognos");
            this.add("Perf");
            this.add("Trace");
            this.add("Audit");
        }
    };
    private static Pattern loggerNamePattern = Pattern.compile("(\\w[\\w-]*(\\.\\w[\\w-]*)+)|(session(\\.\\w[\\w-]*)+)");

    static boolean isValidLoggername(String loggerName) {
        return loggerNamePattern.matcher(loggerName).matches();
    }

    public static boolean testValid(LoggerDefinition ld, ValidationResult result) {
        return LoggerDefinition.testValid(ld, null, result);
    }

    public static boolean testValid(LoggerDefinition ld, Set<String> dupeDetectionSet, ValidationResult result) {
        String loggerName = ld.getName();
        if (StringUtils.isEmpty((String)loggerName)) {
            result.setOk(false);
            result.addMessage(new GlugMessage(Messages.EMPTY_LOGGER_NAME, new String[0]));
            return false;
        }
        if (!LoggerDefinition.isValidLoggername(loggerName)) {
            result.setOk(false);
            result.addMessage(new GlugMessage(Messages.LOGGER_NAME_TOO_SHORT, loggerName));
            return false;
        }
        if (RESERVED_LOGGER_NAMES.contains(loggerName)) {
            result.setOk(false);
            result.addMessage(new GlugMessage(Messages.RESERVED_LOGGER_NAME, loggerName));
            return false;
        }
        if (dupeDetectionSet != null && dupeDetectionSet.contains(loggerName)) {
            result.setOk(false);
            result.addMessage(new GlugMessage(Messages.DUPLICATED_LOGGER_NAME, loggerName));
            return false;
        }
        if (LogLevel.INVALID.equals((Object)ld.level) || ld.level == null) {
            result.setOk(false);
            result.addMessage(new GlugMessage(Messages.INVALID_LEVEL, loggerName));
            return false;
        }
        if (dupeDetectionSet != null) {
            dupeDetectionSet.add(loggerName);
        }
        return true;
    }

    public static ValidationResult validateloggerDefinitions(List<LoggerDefinition> loggerDefinitions) {
        ValidationResult result = new ValidationResult(true);
        if (loggerDefinitions.isEmpty()) {
            result.setOk(false);
            result.addMessage(new GlugMessage(Messages.NO_LOGGERS, new String[0]));
        }
        HashSet dupeDetection = new HashSet();
        loggerDefinitions.stream().forEach(ld -> LoggerDefinition.testValid(ld, dupeDetection, result));
        return result;
    }

    LoggerDefinition() {
    }

    public LoggerDefinition(String name, LogLevel level, Boolean additivity) {
        this.loggerName = name;
        this.level = level;
        this.additivity = additivity;
    }

    public LoggerDefinition(String name, LogLevel level) {
        this(name, level, true);
    }

    public String getName() {
        return this.loggerName;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public boolean isAdditivity() {
        return this.additivity == null ? true : this.additivity;
    }

    public boolean isAdditivitySet() {
        return this.additivity != null;
    }

    public String toString() {
        return String.format("LoggerDefinition: loggerName=%s, level=%s, additivity=%s", new Object[]{this.loggerName, this.level, this.additivity});
    }
}

