/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.internal;

import com.ibm.bi.logging.glug.internal.GlugMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ValidationResult {
    private boolean ok = false;
    private ArrayList<GlugMessage> messages;

    public ValidationResult(boolean ok) {
        this.ok = ok;
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public List<GlugMessage> getMessages() {
        if (this.messages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.messages);
    }

    public void addMessage(GlugMessage message) {
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        this.messages.add(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(" isOK: ").append(this.ok);
        List<GlugMessage> msgs = this.getMessages();
        if (!msgs.isEmpty()) {
            sb.append(" ");
            sb.append(StringUtils.join(this.messages, (String)"; "));
        }
        return super.toString();
    }
}

