/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repository.plugin.configuration.xml;

import com.cognos.cm.repository.plugin.configuration.IQueryConfiguration;
import com.cognos.cm.repository.plugin.configuration.IQueryOptionalClause;
import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repository.plugin.configuration.IRepositoryQueryParameterConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class RepositoryQueryConfiguration
implements IQueryConfiguration {
    private final String name;
    private final Map<String, IRepositoryQueryParameterConfiguration> parameters;
    private final Map<String, IQueryOptionalClause> optionalClauses;
    private final Map<String, IRepositoryObjectProperty> repositoryProperties;
    private final Map<String, IRepositoryObjectProperty> metadataProperties;
    private final List<String> preRequisiteQueryNames;
    private final List<String> subsequentQueryNames;
    private String queryText;
    private String conditionParameterName;
    private String resultProcessorName;

    RepositoryQueryConfiguration(String name) {
        this.name = name;
        this.parameters = new HashMap<String, IRepositoryQueryParameterConfiguration>();
        this.optionalClauses = new HashMap<String, IQueryOptionalClause>();
        this.repositoryProperties = new HashMap<String, IRepositoryObjectProperty>();
        this.metadataProperties = new HashMap<String, IRepositoryObjectProperty>();
        this.preRequisiteQueryNames = new ArrayList<String>();
        this.subsequentQueryNames = new ArrayList<String>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, IRepositoryQueryParameterConfiguration> getParameters() {
        return this.parameters;
    }

    @Override
    public Map<String, IRepositoryObjectProperty> getProperties() {
        return this.metadataProperties;
    }

    @Override
    public String getQueryText() {
        return this.queryText;
    }

    void setQueryText(String text) {
        this.queryText = text;
    }

    void addParameter(IRepositoryQueryParameterConfiguration parameter) {
        this.parameters.put(parameter.getName(), parameter);
    }

    void addProperty(IRepositoryObjectProperty property) {
        this.metadataProperties.put(property.getPropertyMetadataName(), property);
    }

    void addRepositoryProperty(IRepositoryObjectProperty property) {
        this.repositoryProperties.put(property.getPropertyName(), property);
    }

    @Override
    public Map<String, IQueryOptionalClause> getOptionalClauses() {
        return this.optionalClauses;
    }

    void addOptionalClauses(Map<String, IQueryOptionalClause> clauses) {
        this.optionalClauses.putAll(clauses);
    }

    void addOptionalClause(String name, IQueryOptionalClause clause) {
        this.optionalClauses.put(name, clause);
    }

    @Override
    public List<String> getPrerequisiteQueryNames() {
        return this.preRequisiteQueryNames;
    }

    void addPrerequisiteQueryNames(List<String> queryNames) {
        this.preRequisiteQueryNames.addAll(queryNames);
    }

    @Override
    public List<String> getSubsequentQueryNames() {
        return this.subsequentQueryNames;
    }

    void addSubsequentQueryNames(List<String> queryNames) {
        this.subsequentQueryNames.addAll(queryNames);
    }

    @Override
    public String getConditionParameterName() {
        return this.conditionParameterName;
    }

    void setConditionParameterName(String conditionParameterName) {
        this.conditionParameterName = conditionParameterName;
    }

    @Override
    public String getResultProcessorName() {
        return this.resultProcessorName;
    }

    void setResultProcessorName(String resultProcessorName) {
        this.resultProcessorName = resultProcessorName;
    }
}

