/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repositoryPluginAPI;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;

public class HttpClientHelper {
    public static void setMethodPath(HttpClient client, HttpMethod method, URI uri) throws URIException {
        if (!HttpClientHelper.isUriCompatibleWithClient(uri, client)) {
            throw new IllegalArgumentException("Request URI '" + uri.toString() + "' is not compatible with http client URI '" + client.getHostConfiguration().getHostURL() + "'");
        }
        method.setPath(uri.getPath());
        String query = uri.getQuery();
        if (query != null) {
            method.setQueryString(query);
        }
    }

    public static boolean isUriCompatibleWithClient(URI uri, HttpClient client) throws URIException {
        String host = uri.getHost();
        if (host == null) {
            return true;
        }
        HostConfiguration hostCfg = client.getHostConfiguration();
        if (!HttpClientHelper.areStringsEqual(host, hostCfg.getHost())) {
            return false;
        }
        if (hostCfg.getProtocol() != null && !HttpClientHelper.areStringsEqual(uri.getScheme(), hostCfg.getProtocol().getScheme())) {
            return false;
        }
        return hostCfg.getPort() == uri.getPort();
    }

    public static boolean areStringsEqual(String s1, String s2) {
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2 == null;
    }
}

