/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repositoryPluginFramework;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.SearchPathHelper;
import com.ibm.cognos.camaaa.internal.accesscontrol.AccessControlModuleImpl;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlModule;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import java.util.List;

public class AccessControlHelper {
    private static Policy EMPTY_POLICY;

    AccessControlHelper() {
        if (EMPTY_POLICY == null) {
            AccessControlModuleImpl acm = this.getACMInstance();
            this.initializeEmptyPolicy((AccessControlModule)acm);
        }
    }

    AccessControlHelper(AccessControlModule acm) {
        this.initializeEmptyPolicy(acm);
    }

    private AccessControlModuleImpl getACMInstance() {
        try {
            AccessControlModuleImpl acm = AccessControlModuleImpl.getInstance();
            acm.initialize();
            return acm;
        }
        catch (AccessControlException e) {
            throw new RuntimeException("Error initializing AccessControlModule.", e);
        }
    }

    private synchronized void initializeEmptyPolicy(AccessControlModule acm) {
        if (EMPTY_POLICY == null) {
            EMPTY_POLICY = acm.getPolicy();
        }
    }

    public boolean isAdministrator(Identity identity) {
        return EMPTY_POLICY.isAccessGranted(identity, "read");
    }

    public boolean containsAnyCAMID(Identity identity, String camIDsXMLString) throws RepositoryException {
        List<String> camIDList = new SearchPathHelper(camIDsXMLString).getValues();
        return this.containsAnyCAMID(identity, camIDList);
    }

    public boolean containsAnyCAMID(Identity identity, List<String> camIDList) {
        boolean containsAnyCAMID = false;
        if (camIDList != null) {
            for (String camid : camIDList) {
                containsAnyCAMID |= identity.contains(camid);
            }
        }
        return containsAnyCAMID;
    }

    public static AccessControlHelper getInstance() {
        return new AccessControlHelper();
    }
}

