/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repositoryPluginFramework;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.ArrayDelegate;
import com.ibm.cognos.ccl4j.stax.stream.XMLStreamFactory;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class BurstHelper {
    private List<String> values;
    private String xml;

    public BurstHelper(String xmlValue) {
        this.xml = xmlValue;
    }

    public List<String> getValues() throws RepositoryException {
        if (this.values == null) {
            this.values = this.parse();
        }
        return this.values;
    }

    private List<String> parse() throws RepositoryException {
        List<String> values = Collections.emptyList();
        if (this.xml != null && this.xml.length() > 0) {
            try {
                XMLStreamReader reader = XMLStreamFactory.createXMLStreamReader((String)this.xml);
                ArrayDelegate delegate = this.getDelegate(reader);
                while (delegate.hasNext()) {
                    delegate.next();
                }
                values = delegate.getValues();
            }
            catch (XMLStreamException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        return values;
    }

    public static String getDirectoryFan(String recipient) {
        return Integer.toHexString(new HashCodeBuilder(17, 37).append((Object)recipient).toHashCode());
    }

    public static String getDirectoryName(byte[] recipientBytes) throws RepositoryException {
        try {
            return new String(Base64.getEncoder().encode(recipientBytes), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    protected abstract ArrayDelegate getDelegate(XMLStreamReader var1);
}

