/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repositoryPluginFramework;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IRepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import java.util.HashMap;
import java.util.Map;

public class RepositoryConnectionString
implements IRepositoryConnectionString {
    private static final String REPOSITORY_CONNECTION_STRING_EQUALS = "=";
    private static final String REPOSITORY_CONNECTION_STRING_DELIMITER = ";";
    private static final int NUMBER_OF_REQUIRED_TOKENS_IN_CONNECTION_STRING = 5;
    private static final String REPOSITORY_CONNECTION_STRING_REPOSITORYTYPE_DELIMITER = "-";
    private String connectionString;
    private Map<String, String> mandatoryParameters;
    private Map<String, String> optionalParameters;
    private String repositoryType;

    public RepositoryConnectionString(String connectionString) throws RepositoryException {
        this.connectionString = connectionString;
        this.parseConnectionString();
    }

    private void parseConnectionString() throws RepositoryException {
        this.mandatoryParameters = new HashMap<String, String>();
        this.optionalParameters = new HashMap<String, String>();
        if (this.isMockDriver()) {
            this.parseMockDriverConnectionString();
        } else {
            this.parseRealDriverConnectionString();
        }
    }

    private boolean isMockDriver() {
        return this.connectionString.endsWith(":") && this.connectionString.length() > 1;
    }

    private void parseRealDriverConnectionString() throws RepositoryException {
        String[] tokens = this.connectionString.split(REPOSITORY_CONNECTION_STRING_DELIMITER);
        if (tokens.length < 5) {
            Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.cannotParseConnectionString);
            throw new RepositoryException(msg);
        }
        for (int i = 0; i < tokens.length; ++i) {
            boolean isOptionalToken;
            String token = tokens[i];
            boolean isRepositoryTypeToken = i == 2;
            boolean bl = isOptionalToken = i >= 5;
            if (isRepositoryTypeToken) {
                this.parseRepositoryTypeToken(token);
                continue;
            }
            String[] nameValueTokens = this.parseNameValueToken(token);
            if (nameValueTokens.length != 2) continue;
            if (isOptionalToken) {
                this.optionalParameters.put(nameValueTokens[0], nameValueTokens[1]);
                continue;
            }
            this.mandatoryParameters.put(nameValueTokens[0], nameValueTokens[1]);
        }
    }

    private void parseMockDriverConnectionString() {
        String driverClassName = this.connectionString.substring(0, this.connectionString.length() - 1);
        this.mandatoryParameters.put("DRIVER_NAME", driverClassName);
        this.repositoryType = null;
    }

    private String[] parseNameValueToken(String token) {
        return token.split(REPOSITORY_CONNECTION_STRING_EQUALS);
    }

    private void parseRepositoryTypeToken(String token) throws RepositoryException {
        String[] repositoryTypeTokens = token.split(REPOSITORY_CONNECTION_STRING_REPOSITORYTYPE_DELIMITER);
        if (repositoryTypeTokens.length != 3) {
            Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.cannotParseRepositoryType).param("ConnectionString", this.connectionString);
            throw new RepositoryException(msg);
        }
        this.repositoryType = repositoryTypeTokens[2];
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    public String getMandatoryParameter(String parameterName) {
        return this.mandatoryParameters.get(parameterName);
    }

    @Override
    public String getOptionalParameter(String parameterName) {
        return this.optionalParameters.get(parameterName);
    }

    @Override
    public Map<String, String> getOptionalParameters() {
        return this.optionalParameters;
    }

    @Override
    public String getRepositoryType() {
        return this.repositoryType;
    }
}

