/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repositoryPluginFramework;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.ExceptionUtils;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import java.util.Locale;
import java.util.Properties;

public class RepositoryLogger {
    private static final String UNKNOWN = "unknown";
    private static final String SEPERATOR = "/";
    private static final String CONNECTION_STRING = "connectionString";
    private Locale serverLocale;
    private final LogTypedLogger repositoryLogger;
    private static final RepositoryLogger instance = new RepositoryLogger();

    RepositoryLogger() {
        this(LogTypedLogger.getInstance((String)"Audit.CM.ECM", LogAuditIndication.class));
    }

    RepositoryLogger(LogTypedLogger logger) {
        this.repositoryLogger = logger;
    }

    public static void logArchiveSuccess(IDataDescriptor metadata) {
        instance.archiveSuccess(metadata);
    }

    public static void logFailedArchive(IDataDescriptor metadata, Properties properties, Throwable e) {
        instance.failedArchive(metadata, properties, e);
    }

    public static void logWriteSuccess(String objectID) {
        instance.writeSuccess(objectID);
    }

    public static void logDeleteSuccess(String objectID) {
        instance.deleteSuccess(objectID);
    }

    public static void logFailure(String msg) {
        instance.failure(msg);
    }

    public static void logFailure(String msg, Throwable e) {
        instance.failure(msg, e);
    }

    public static void logFailure(Message msg) {
        instance.failure(msg);
    }

    public static void logFailure(Message msg, Throwable e) {
        instance.failure(msg, e);
    }

    void archiveSuccess(IDataDescriptor metadata) {
        try {
            if (!this.repositoryLogger.isDebugEnabled()) {
                return;
            }
            String reportStoreID = metadata.getProperty("reportStoreID").getStringValue();
            String outputStoreID = this.getOutputStoreID(metadata);
            Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.archivesuccess).param("outputID", outputStoreID).param("reportID", reportStoreID);
            this.repositoryLogger.debug(this.getMessageString(msg));
        }
        catch (Exception e) {
            this.repositoryLogger.error(this.getMessageString(new Message((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError)), (Throwable)e);
        }
    }

    void deleteSuccess(String objectID) {
        if (!this.repositoryLogger.isDebugEnabled()) {
            return;
        }
        Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.deleteSuccess).param("objectID", objectID);
        this.repositoryLogger.info(this.getMessageString(msg));
    }

    void writeSuccess(String objectID) {
        if (!this.repositoryLogger.isDebugEnabled()) {
            return;
        }
        Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.writeSuccess).param("objectID", objectID);
        this.repositoryLogger.debug(this.getMessageString(msg));
    }

    void failedArchive(IDataDescriptor metadata, Properties properties, Throwable e) {
        if (metadata == null || properties == null) {
            this.noData();
            return;
        }
        String archiveRoot = properties.getProperty(CONNECTION_STRING);
        archiveRoot = archiveRoot != null ? archiveRoot : UNKNOWN;
        IDataDescriptorProperty prop = metadata.getProperty("reportStoreID");
        String reportStoreID = prop != null ? prop.getStringValue() : UNKNOWN;
        String outputStoreID = this.getOutputStoreID(metadata);
        StringBuilder failureDetails = new StringBuilder();
        if (e.getMessage() != null) {
            failureDetails.append(e.getMessage());
        }
        failureDetails.append(ExceptionUtils.getRootStackTrace((Throwable)e));
        Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.archivefail).param("outputID", outputStoreID).param("reportID", reportStoreID).param(CONNECTION_STRING, archiveRoot).param("trace", failureDetails.toString());
        this.repositoryLogger.error(this.getMessageString(msg));
    }

    void failure(String msg) {
        this.repositoryLogger.error(msg);
    }

    void failure(String msg, Throwable e) {
        this.repositoryLogger.error(msg, e);
    }

    void failure(Message msg) {
        this.repositoryLogger.error(this.getMessageString(msg));
    }

    void failure(Message msg, Throwable e) {
        this.repositoryLogger.error(this.getMessageString(msg), e);
    }

    private void noData() {
        Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.archivefailnodata);
        this.repositoryLogger.error(this.getMessageString(msg));
    }

    private String getMessageString(Message msg) {
        return msg.format(this.getServerLocale());
    }

    private synchronized Locale getServerLocale() {
        try {
            if (this.serverLocale != null) {
                return this.serverLocale;
            }
            ICCLConfiguration config = CCLConfigurationFactory.createConfiguration();
            String locale = config.getValue("serverLocale", true);
            this.serverLocale = new Locale(config.normalizeLocale(locale));
        }
        catch (CCLConfigurationException e) {
            this.serverLocale = Locale.getDefault();
        }
        return this.serverLocale;
    }

    private String getOutputStoreID(IDataDescriptor metadata) {
        IDataDescriptorProperty documentObjectID = metadata.getProperty("documentObjectID");
        IDataDescriptorProperty outputStoreID = metadata.getProperty("reportOutputStoreID");
        if (documentObjectID != null && outputStoreID != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(outputStoreID.getStringValue());
            builder.append(SEPERATOR);
            builder.append(documentObjectID.getStringValue());
            return builder.toString();
        }
        if (documentObjectID != null) {
            return documentObjectID.toString();
        }
        if (outputStoreID != null) {
            outputStoreID.toString();
        }
        return UNKNOWN;
    }
}

