/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repositoryPluginFramework;

import com.cognos.cm.repositoryPluginFramework.IRepositoryServiceHelper;
import java.net.URLEncoder;

public class RepositoryServiceHelper
implements IRepositoryServiceHelper {
    private static final String SCRIPT = "<script";
    private String gateway;
    private String documentID;
    private String dataSourceName;
    private String reportID;
    private String outputFormat;
    private String camPassportCookie;

    @Override
    public String createRelativeViewOutputURL(String documentID, String reportID, String dataSourceID) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("/repository/sid/");
        buffer.append(this.encode(dataSourceID));
        if (reportID != null) {
            buffer.append("/rid/");
            buffer.append(this.encode(reportID));
        }
        buffer.append("/oid/");
        buffer.append(this.encode(documentID));
        buffer.append("/content");
        return buffer.toString();
    }

    @Override
    public String createRelativeViewOutputURL(String documentId, String dataSourceName) throws Exception {
        return this.createRelativeViewOutputURL(documentId, "", dataSourceName);
    }

    private String encode(String parameter) throws Exception {
        return URLEncoder.encode(parameter, "UTF-8");
    }

    @Override
    public String createViewOutputURL() throws Exception {
        String gateway = this.getGateway();
        String documentID = this.getDocumentID();
        String dataSourceID = this.getDataSourceID();
        String reportID = this.getReportID();
        StringBuffer buffer = new StringBuffer();
        if (gateway != null && gateway.endsWith("/")) {
            gateway = gateway.substring(0, gateway.length() - 1);
        }
        if (gateway != null) {
            buffer.append(gateway);
        }
        buffer.append(this.createRelativeViewOutputURL(documentID, reportID, dataSourceID));
        return buffer.toString();
    }

    @Override
    public String getReportID() {
        return this.reportID;
    }

    @Override
    public void setDocumentID(String documentID) {
        this.documentID = documentID;
    }

    @Override
    public void setReportID(String reportID) {
        this.reportID = reportID;
    }

    @Override
    public void setCamPassportCookie(String camPassportCookie) {
        this.camPassportCookie = camPassportCookie;
    }

    @Override
    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = this.removeJavascript(dataSourceName);
    }

    private String removeJavascript(String text) {
        if (text == null) {
            return null;
        }
        int indexOfScript = text.indexOf(SCRIPT);
        while (indexOfScript > -1) {
            text = text.replaceAll(SCRIPT, "");
            indexOfScript = text.indexOf(SCRIPT);
        }
        return text;
    }

    @Override
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Override
    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    public String getCamPassportCookie() {
        return this.camPassportCookie;
    }

    @Override
    public String getDataSourceID() {
        return this.dataSourceName;
    }

    @Override
    public String getDocumentID() {
        return this.documentID;
    }

    @Override
    public String getGateway() {
        return this.gateway;
    }

    @Override
    public String getOutputFormat() {
        return this.outputFormat;
    }
}

