/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repositoryPluginFramework.identity;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.client.cmapi.HttpCommand;
import com.cognos.cm.client.cmapi.HttpCommandFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cm.repositoryPluginFramework.identity.ExternalIdentity;
import com.cognos.cm.repositoryPluginFramework.identity.IdentityProvider;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import java.util.LinkedList;
import javax.servlet.http.Cookie;
import org.apache.commons.httpclient.StatusLine;

public class ExternalIdentityProvider
implements IdentityProvider {
    private static final String IDENTITY_REQUEST = "/1.0/objects/~~/identity";
    ICCLConfiguration config;
    HttpCommandFactory factory;
    HttpCommand externalCommand;

    public ExternalIdentityProvider() {
    }

    ExternalIdentityProvider(HttpCommand command) {
        this.externalCommand = command;
    }

    @Override
    public void setCommandFactory(HttpCommandFactory factory) {
        this.factory = factory;
    }

    @Override
    public Identity getIdentity(MessageContext mc) throws RepositoryException {
        try {
            HttpCommand command = this.getCommand(mc);
            return this.getIdentity(command);
        }
        catch (Exception e) {
            throw new RepositoryException(RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public Identity getIdentity(String cookieValue) throws RepositoryException {
        try {
            HttpCommand command = this.getCommand(cookieValue);
            return this.getIdentity(command);
        }
        catch (Exception e) {
            throw new RepositoryException(RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    private Identity getIdentity(HttpCommand command) throws Exception {
        int responseCode = command.execute();
        LinkedList<String> identityList = new LinkedList<String>();
        if (200 == responseCode) {
            JSONArray response = (JSONArray)JSON.parse((String)command.getResponseBody());
            for (Object arrayVal : response) {
                identityList.add(arrayVal.toString());
            }
            return new ExternalIdentity(identityList);
        }
        if (401 == responseCode) {
            throw this.buildRequestException(RepositoryPluginErrors.REP_API.authenticationRequired, command);
        }
        throw this.buildRequestException(RepositoryPluginErrors.REP_API.repositoryError, command);
    }

    private RepositoryException buildRequestException(RepositoryPluginErrors.REP_API errorCode, HttpCommand command) {
        StatusLine status = command.getStatusLine();
        String statusMsg = status.getStatusCode() + ": " + status.getReasonPhrase();
        RuntimeException rootException = new RuntimeException(statusMsg);
        return new RepositoryException(errorCode, (Throwable)rootException);
    }

    protected HttpCommand getCommand(MessageContext mc) {
        if (this.externalCommand == null) {
            return this.factory.getCommand(mc, IDENTITY_REQUEST);
        }
        return this.externalCommand;
    }

    private HttpCommand getCommand(String cookieValue) {
        if (this.externalCommand == null) {
            Cookie camPassport = new Cookie("cam_passport", cookieValue);
            return this.factory.getCommand(camPassport, IDENTITY_REQUEST);
        }
        return this.externalCommand;
    }
}

